/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.util.Supplier;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.search.IndexSearcher;

public class IndexConsistencyUtils {
    private static final Logger log = Logger.getLogger(IndexConsistencyUtils.class);

    private IndexConsistencyUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isIndexConsistent(String name, int expectedCount, IndexSearcher searcher) throws IOException {
        try {
            int tolerance;
            int delta;
            int actualCount = searcher.getIndexReader().numDocs();
            if (log.isDebugEnabled()) {
                log.debug((Object)("isIndexConsistent: " + name + ": expectedCount=" + expectedCount + "; actualCount=" + actualCount));
            }
            if (expectedCount >= 0 && (delta = Math.abs(expectedCount - actualCount)) > (tolerance = Math.max(10, expectedCount / 10))) {
                log.warn((Object)("Index consistency check failed for index '" + name + "': expectedCount=" + expectedCount + "; actualCount=" + actualCount));
                boolean bl = false;
                return bl;
            }
        }
        finally {
            searcher.close();
        }
        return true;
    }

    public static boolean isIndexConsistent(String name, int expectedCount, Supplier<IndexSearcher> supplier) {
        try {
            return IndexConsistencyUtils.isIndexConsistent(name, expectedCount, (IndexSearcher)supplier.get());
        }
        catch (Exception ex) {
            log.warn((Object)("Index consistency check failed for index '" + name + "': " + ex));
            return false;
        }
    }
}

