/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen.issuetype;

import com.atlassian.core.ofbiz.association.AssociationManager;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntityImpl;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeImpl;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class DefaultIssueTypeScreenSchemeManager
implements IssueTypeScreenSchemeManager {
    private final OfBizDelegator ofBizDelegator;
    private final ConstantsManager constantsManager;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private final AssociationManager associationManager;
    private final ConcurrentMap<Long, Long> projectAssociationCache = new ConcurrentHashMap<Long, Long>();
    private final ConcurrentMap<Long, IssueTypeScreenScheme> schemeCache = new ConcurrentHashMap<Long, IssueTypeScreenScheme>();

    public DefaultIssueTypeScreenSchemeManager(OfBizDelegator ofBizDelegator, ConstantsManager constantsManager, FieldScreenSchemeManager fieldScreenSchemeManager, AssociationManager associationManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.constantsManager = constantsManager;
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.associationManager = associationManager;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    public Collection<IssueTypeScreenScheme> getIssueTypeScreenSchemes() {
        return this.buildIssueTypeScreenSchemes(this.ofBizDelegator.findAll("IssueTypeScreenScheme", EasyList.build((Object)"name")));
    }

    private Collection<IssueTypeScreenScheme> buildIssueTypeScreenSchemes(List<GenericValue> issueTypeScreenSchemeGVs) {
        LinkedList<IssueTypeScreenScheme> issueTypeScreenSchemes = new LinkedList<IssueTypeScreenScheme>();
        for (GenericValue element : issueTypeScreenSchemeGVs) {
            issueTypeScreenSchemes.add(this.buildIssueTypeScreenScheme(element));
        }
        return issueTypeScreenSchemes;
    }

    protected IssueTypeScreenScheme buildIssueTypeScreenScheme(GenericValue genericValue) {
        return new IssueTypeScreenSchemeImpl(this, genericValue);
    }

    public IssueTypeScreenScheme getIssueTypeScreenScheme(Long id) {
        IssueTypeScreenScheme issueTypeScreenScheme = (IssueTypeScreenScheme)this.schemeCache.get(id);
        if (issueTypeScreenScheme == null) {
            GenericValue issueTypeScreenSchemeGV = this.getOfBizDelegator().findById("IssueTypeScreenScheme", id);
            issueTypeScreenScheme = this.buildIssueTypeScreenScheme(issueTypeScreenSchemeGV);
            IssueTypeScreenScheme result = this.schemeCache.putIfAbsent(issueTypeScreenScheme.getId(), issueTypeScreenScheme);
            return result == null ? issueTypeScreenScheme : result;
        }
        return issueTypeScreenScheme;
    }

    public IssueTypeScreenScheme getIssueTypeScreenScheme(GenericValue project) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        Long projectId = project.getLong("id");
        Long schemeId = (Long)this.projectAssociationCache.get(projectId);
        if (schemeId != null) {
            return this.getIssueTypeScreenScheme(schemeId);
        }
        IssueTypeScreenScheme issueTypeScreenScheme = null;
        try {
            GenericValue issueTypeScreenSchemeGV = EntityUtil.getOnly(this.getAssociationManager().getSinkFromSource(project, "IssueTypeScreenScheme", "ProjectScheme", false));
            if (issueTypeScreenSchemeGV != null) {
                issueTypeScreenScheme = this.buildIssueTypeScreenScheme(issueTypeScreenSchemeGV);
                this.projectAssociationCache.putIfAbsent(projectId, issueTypeScreenScheme.getId());
            }
            return issueTypeScreenScheme;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while retrieving a iisue type screen scheme.", (Throwable)e);
        }
    }

    public IssueTypeScreenScheme getIssueTypeScreenScheme(Project project) {
        return this.getIssueTypeScreenScheme(project.getGenericValue());
    }

    public FieldScreenScheme getFieldScreenScheme(Issue issue) {
        Project project = issue.getProjectObject();
        if (project == null) {
            throw new RuntimeException("Issue '" + issue + "' has no project");
        }
        IssueTypeScreenScheme issueTypeScreenScheme = this.getIssueTypeScreenScheme(project.getGenericValue());
        IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(issue.getIssueTypeObject().getId());
        if (issueTypeScreenSchemeEntity == null && (issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(null)) == null) {
            throw new IllegalStateException("No default entity for issue type screen scheme with id '" + issueTypeScreenScheme.getId() + "'.");
        }
        return issueTypeScreenSchemeEntity.getFieldScreenScheme();
    }

    public Collection getIssueTypeScreenSchemeEntities(IssueTypeScreenScheme issueTypeScreenScheme) {
        LinkedList<IssueTypeScreenSchemeEntity> issueTypeScreenSchemeEntities = new LinkedList<IssueTypeScreenSchemeEntity>();
        List issueTypeScreenSchemeEntitymGVs = this.getOfBizDelegator().findByAnd("IssueTypeScreenSchemeEntity", EasyMap.build((Object)"scheme", (Object)issueTypeScreenScheme.getId()));
        for (GenericValue issueTypeScreenSchemeEntityGV : issueTypeScreenSchemeEntitymGVs) {
            IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = this.buildIssueTypeScreenSchemeEntity(issueTypeScreenSchemeEntityGV);
            issueTypeScreenSchemeEntity.setIssueTypeScreenScheme(issueTypeScreenScheme);
            issueTypeScreenSchemeEntities.add(issueTypeScreenSchemeEntity);
        }
        return issueTypeScreenSchemeEntities;
    }

    protected IssueTypeScreenSchemeEntity buildIssueTypeScreenSchemeEntity(GenericValue genericValue) {
        IssueTypeScreenSchemeEntityImpl issueTypeScreenSchemeEntity = new IssueTypeScreenSchemeEntityImpl((IssueTypeScreenSchemeManager)this, genericValue, this.fieldScreenSchemeManager, this.constantsManager);
        issueTypeScreenSchemeEntity.setIssueTypeId(genericValue.getString("issuetype"));
        issueTypeScreenSchemeEntity.setFieldScreenScheme(this.fieldScreenSchemeManager.getFieldScreenScheme(genericValue.getLong("fieldscreenscheme")));
        return issueTypeScreenSchemeEntity;
    }

    public void createIssueTypeScreenScheme(IssueTypeScreenScheme issueTypeScreenScheme) {
        Map params = EasyMap.build((Object)"name", (Object)issueTypeScreenScheme.getName(), (Object)"description", (Object)issueTypeScreenScheme.getDescription());
        if (issueTypeScreenScheme.getId() != null) {
            params.put("id", issueTypeScreenScheme.getId());
        }
        GenericValue fieldScreenSchemeGV = this.ofBizDelegator.createValue("IssueTypeScreenScheme", params);
        issueTypeScreenScheme.setGenericValue(fieldScreenSchemeGV);
    }

    public void updateIssueTypeScreenScheme(IssueTypeScreenScheme issueTypeScreenScheme) {
        this.ofBizDelegator.store(issueTypeScreenScheme.getGenericValue());
        this.schemeCache.remove(issueTypeScreenScheme.getId());
    }

    public void removeIssueTypeSchemeEntities(IssueTypeScreenScheme issueTypeScreenScheme) {
        this.getOfBizDelegator().removeByAnd("IssueTypeScreenSchemeEntity", EasyMap.build((Object)"scheme", (Object)issueTypeScreenScheme.getId()));
    }

    public void removeIssueTypeScreenScheme(IssueTypeScreenScheme issueTypeScreenScheme) {
        this.getOfBizDelegator().removeValue(issueTypeScreenScheme.getGenericValue());
        this.schemeCache.remove(issueTypeScreenScheme.getId());
    }

    public void createIssueTypeScreenSchemeEntity(IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity) {
        String issueTypeId = issueTypeScreenSchemeEntity.getIssueTypeId();
        GenericValue issueTypeScreenSchemeEntityGV = this.ofBizDelegator.createValue("IssueTypeScreenSchemeEntity", EasyMap.build((Object)"issuetype", (Object)issueTypeId, (Object)"fieldscreenscheme", (Object)issueTypeScreenSchemeEntity.getFieldScreenScheme().getId(), (Object)"scheme", (Object)issueTypeScreenSchemeEntity.getIssueTypeScreenScheme().getId()));
        issueTypeScreenSchemeEntity.setGenericValue(issueTypeScreenSchemeEntityGV);
        this.schemeCache.remove(issueTypeScreenSchemeEntity.getFieldScreenScheme().getId());
    }

    public void updateIssueTypeScreenSchemeEntity(IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity) {
        this.ofBizDelegator.store(issueTypeScreenSchemeEntity.getGenericValue());
        this.schemeCache.remove(issueTypeScreenSchemeEntity.getFieldScreenScheme().getId());
    }

    public void removeIssueTypeScreenSchemeEntity(IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity) {
        this.ofBizDelegator.removeValue(issueTypeScreenSchemeEntity.getGenericValue());
        this.schemeCache.remove(issueTypeScreenSchemeEntity.getIssueTypeScreenScheme().getId());
    }

    public Collection<IssueTypeScreenScheme> getIssueTypeScreenSchemes(FieldScreenScheme fieldScreenScheme) {
        LinkedList<IssueTypeScreenScheme> issueTypeScreenSchemes = new LinkedList<IssueTypeScreenScheme>();
        HashSet<Long> issueTypeScreenSchemeIds = new HashSet<Long>();
        List issueTypeScreenSchemeEntityGVs = this.ofBizDelegator.findByAnd("IssueTypeScreenSchemeEntity", EasyMap.build((Object)"fieldscreenscheme", (Object)fieldScreenScheme.getId()));
        for (GenericValue issueTypeScreenSchemeEntityGV : issueTypeScreenSchemeEntityGVs) {
            issueTypeScreenSchemeIds.add(issueTypeScreenSchemeEntityGV.getLong("scheme"));
        }
        for (Long element : issueTypeScreenSchemeIds) {
            issueTypeScreenSchemes.add(this.getIssueTypeScreenScheme(element));
        }
        return issueTypeScreenSchemes;
    }

    public void addSchemeAssociation(GenericValue project, IssueTypeScreenScheme issueTypeScreenScheme) {
        if (project == null) {
            throw new IllegalArgumentException("Project passed must not be null.");
        }
        try {
            IssueTypeScreenScheme oldIssueTypeScreenScheme = this.getIssueTypeScreenScheme(project);
            if (oldIssueTypeScreenScheme != null) {
                if (!oldIssueTypeScreenScheme.equals(issueTypeScreenScheme)) {
                    this.removeSchemeAssociation(project, oldIssueTypeScreenScheme);
                    if (issueTypeScreenScheme != null && issueTypeScreenScheme.getGenericValue() != null) {
                        this.associationManager.createAssociation(project, issueTypeScreenScheme.getGenericValue(), "ProjectScheme");
                    }
                }
            } else if (issueTypeScreenScheme != null && issueTypeScreenScheme.getGenericValue() != null) {
                this.associationManager.createAssociation(project, issueTypeScreenScheme.getGenericValue(), "ProjectScheme");
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while associating project and issue type screen scheme.", (Throwable)e);
        }
    }

    public void addSchemeAssociation(Project project, IssueTypeScreenScheme issueTypeScreenScheme) {
        this.addSchemeAssociation(project.getGenericValue(), issueTypeScreenScheme);
    }

    public void removeSchemeAssociation(GenericValue project, IssueTypeScreenScheme issueTypeScreenScheme) {
        try {
            if (issueTypeScreenScheme != null && issueTypeScreenScheme.getGenericValue() != null) {
                this.getAssociationManager().removeAssociation(project, issueTypeScreenScheme.getGenericValue(), "ProjectScheme");
                this.projectAssociationCache.remove(project.getLong("id"));
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Error occurred while removing association between project and issue type screen scheme.", (Throwable)e);
        }
    }

    public void removeSchemeAssociation(Project project, IssueTypeScreenScheme issueTypeScreenScheme) {
        this.removeSchemeAssociation(project.getGenericValue(), issueTypeScreenScheme);
    }

    public Collection<GenericValue> getProjects(IssueTypeScreenScheme issueTypeScreenScheme) {
        try {
            List<GenericValue> projects = this.associationManager.getSourceFromSink(issueTypeScreenScheme.getGenericValue(), "Project", "ProjectScheme", false);
            Collections.sort(projects, OfBizComparators.NAME_COMPARATOR);
            return projects;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public void associateWithDefaultScheme(GenericValue project) {
        this.addSchemeAssociation(project, this.getDefaultScheme());
    }

    public void associateWithDefaultScheme(Project project) {
        this.associateWithDefaultScheme(project.getGenericValue());
    }

    public IssueTypeScreenScheme getDefaultScheme() {
        return this.getIssueTypeScreenScheme(IssueTypeScreenScheme.DEFAULT_SCHEME_ID);
    }

    public void refresh() {
        this.schemeCache.clear();
        this.projectAssociationCache.clear();
    }

    protected OfBizDelegator getOfBizDelegator() {
        return this.ofBizDelegator;
    }

    protected AssociationManager getAssociationManager() {
        return this.associationManager;
    }
}

