/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer;

import com.atlassian.jira.issue.fields.AffectedVersionsSystemField;
import com.atlassian.jira.issue.fields.ComponentsSystemField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FixVersionsSystemField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.renderer.HackyFieldRendererRegistry;
import com.atlassian.jira.issue.fields.renderer.HackyRendererType;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DefaultHackyFieldRendererRegistry
implements HackyFieldRendererRegistry {
    private static final Map<Class<? extends OrderableField>, Set<HackyRendererType>> systemFieldRenderers = new HashMap<Class<? extends OrderableField>, Set<HackyRendererType>>();
    private static final Map<String, Set<HackyRendererType>> customFieldRenderers = new HashMap<String, Set<HackyRendererType>>();
    private static final String CUSTOM_FIELD_KEY_PREFIX = "com.atlassian.jira.plugin.system.customfieldtypes:";

    public boolean shouldOverrideDefaultRenderers(OrderableField field) {
        Assertions.notNull((String)"field", (Object)field);
        if (field instanceof CustomField) {
            String type = ((CustomField)field).getCustomFieldType().getKey();
            return customFieldRenderers.containsKey(type);
        }
        return systemFieldRenderers.containsKey(field.getClass());
    }

    public Set<HackyRendererType> getRendererTypes(OrderableField field) {
        Assertions.notNull((String)"field", (Object)field);
        if (!this.shouldOverrideDefaultRenderers(field)) {
            return Collections.emptySet();
        }
        if (field instanceof CustomField) {
            String type = ((CustomField)field).getCustomFieldType().getKey();
            return customFieldRenderers.get(type);
        }
        return systemFieldRenderers.get(field.getClass());
    }

    public HackyRendererType getDefaultRendererType(OrderableField field) {
        Assertions.notNull((String)"field", (Object)field);
        if (this.shouldOverrideDefaultRenderers(field)) {
            return HackyRendererType.FROTHER_CONTROL;
        }
        return null;
    }

    static {
        Set renderers = CollectionBuilder.newBuilder((Object[])new HackyRendererType[]{HackyRendererType.SELECT_LIST, HackyRendererType.FROTHER_CONTROL}).asImmutableListOrderedSet();
        systemFieldRenderers.put(FixVersionsSystemField.class, renderers);
        systemFieldRenderers.put(AffectedVersionsSystemField.class, renderers);
        systemFieldRenderers.put(ComponentsSystemField.class, renderers);
        customFieldRenderers.put("com.atlassian.jira.plugin.system.customfieldtypes:multiversion", renderers);
    }
}

