/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.field;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldDescriptionHelper;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.renderer.HackyFieldRendererRegistry;
import org.apache.commons.lang.builder.ToStringBuilder;

public class FieldLayoutItemImpl
implements FieldLayoutItem {
    private final OrderableField orderableField;
    private final String fieldDescription;
    private final boolean hidden;
    private final boolean required;
    private final String rendererType;
    private final FieldLayout fieldLayout;
    private final FieldDescriptionHelper fieldDescriptionHelper;

    FieldLayoutItemImpl(OrderableField orderableField, String description, boolean hidden, boolean required, String rendererType, FieldLayout fieldLayout, FieldManager fieldManager, FieldDescriptionHelper fieldDescriptionHelper) {
        if (hidden && !fieldManager.isHideableField((Field)orderableField)) {
            throw new IllegalArgumentException("Trying to create a Hidden Field Layout Item for a Field that is not hideable. '" + orderableField + "'.");
        }
        this.orderableField = orderableField;
        this.fieldDescription = description;
        this.hidden = hidden;
        this.required = required;
        this.rendererType = rendererType;
        this.fieldLayout = fieldLayout;
        this.fieldDescriptionHelper = fieldDescriptionHelper;
    }

    public OrderableField getOrderableField() {
        return this.orderableField;
    }

    public String getFieldDescription() {
        String description = null;
        if (this.fieldDescription != null) {
            description = this.fieldDescription;
            if (this.fieldDescriptionHelper != null) {
                description = this.fieldDescriptionHelper.getDescription(this.fieldDescription);
            }
        } else {
            FieldManager fieldManager = this.getFieldManager();
            if (fieldManager.isCustomField((Field)this.getOrderableField())) {
                CustomField customField = fieldManager.getCustomField(this.getOrderableField().getId());
                description = customField.getDescriptionProperty().getViewHtml();
            }
        }
        return description;
    }

    public String getRawFieldDescription() {
        FieldManager fieldManager;
        String description = this.fieldDescription;
        if (description == null && (fieldManager = this.getFieldManager()).isCustomField((Field)this.getOrderableField())) {
            CustomField customField = fieldManager.getCustomField(this.getOrderableField().getId());
            description = customField.getDescription();
        }
        return description;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getRendererType() {
        return this.rendererType;
    }

    public FieldLayout getFieldLayout() {
        return this.fieldLayout;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldLayoutItem)) {
            return false;
        }
        FieldLayoutItem fieldLayoutItem = (FieldLayoutItem)o;
        if (this.hidden != fieldLayoutItem.isHidden()) {
            return false;
        }
        if (this.required != fieldLayoutItem.isRequired()) {
            return false;
        }
        return !(this.orderableField != null ? !this.orderableField.equals(fieldLayoutItem.getOrderableField()) : fieldLayoutItem.getOrderableField() != null);
    }

    public int hashCode() {
        int result = this.orderableField != null ? this.orderableField.hashCode() : 0;
        result = 29 * result + (this.hidden ? 1 : 0);
        result = 29 * result + (this.required ? 1 : 0);
        return result;
    }

    public int compareTo(FieldLayoutItem fieldLayoutItem) {
        if (fieldLayoutItem == null) {
            return 1;
        }
        if (fieldLayoutItem.getOrderableField() == null) {
            if (this.getOrderableField() == null) {
                return 0;
            }
            return 1;
        }
        if (this.getOrderableField() == null) {
            return -1;
        }
        return this.getOrderableField().compareTo((Object)fieldLayoutItem.getOrderableField());
    }

    FieldManager getFieldManager() {
        return ComponentAccessor.getFieldManager();
    }

    public static class Builder {
        private OrderableField orderableField = null;
        private String fieldDescription = null;
        private boolean hidden = false;
        private boolean required = false;
        private String rendererType = null;
        private FieldLayout fieldLayout = null;
        private FieldManager fieldManager = null;
        private FieldDescriptionHelper fieldDescriptionHelper = null;

        public Builder() {
        }

        public Builder(FieldLayoutItem rhs) {
            this.orderableField = rhs.getOrderableField();
            this.fieldDescription = rhs.getRawFieldDescription();
            this.hidden = rhs.isHidden();
            this.required = rhs.isRequired();
            this.rendererType = rhs.getRendererType();
            this.fieldLayout = rhs.getFieldLayout();
        }

        public FieldLayoutItemImpl build() {
            if (this.fieldManager == null) {
                this.fieldManager = ComponentAccessor.getFieldManager();
            }
            if (this.fieldDescriptionHelper == null) {
                this.fieldDescriptionHelper = (FieldDescriptionHelper)ComponentAccessor.getComponent(FieldDescriptionHelper.class);
            }
            if (this.rendererType == null) {
                HackyFieldRendererRegistry hackyFieldRendererRegistry;
                if (this.orderableField != null && (hackyFieldRendererRegistry = (HackyFieldRendererRegistry)ComponentAccessor.getComponentOfType(HackyFieldRendererRegistry.class)).shouldOverrideDefaultRenderers(this.orderableField)) {
                    this.rendererType = hackyFieldRendererRegistry.getDefaultRendererType(this.orderableField).getKey();
                }
                if (this.rendererType == null) {
                    this.rendererType = "jira-text-renderer";
                }
            }
            return new FieldLayoutItemImpl(this.orderableField, this.fieldDescription, this.hidden, this.required, this.rendererType, this.fieldLayout, this.fieldManager, this.fieldDescriptionHelper);
        }

        public Builder setFieldDescription(String fieldDescription) {
            this.fieldDescription = fieldDescription;
            return this;
        }

        public Builder setFieldLayout(FieldLayout fieldLayout) {
            this.fieldLayout = fieldLayout;
            return this;
        }

        public Builder setHidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Builder setOrderableField(OrderableField orderableField) {
            this.orderableField = orderableField;
            return this;
        }

        public Builder setRendererType(String rendererType) {
            this.rendererType = rendererType;
            return this;
        }

        public Builder setRequired(boolean required) {
            this.required = required;
            return this;
        }

        public Builder setFieldManager(FieldManager fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }
    }
}

