/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.AbstractVersionsSystemField;
import com.atlassian.jira.issue.fields.AffectedVersionsField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.AffectedVersionsRestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.RestFieldOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.util.VersionHelperBean;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.handlers.AffectedVersionSearchHandlerFactory;
import com.atlassian.jira.issue.statistics.RaisedInVersionStatisticsMapper;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class AffectedVersionsSystemField
extends AbstractVersionsSystemField
implements AffectedVersionsField,
RestFieldOperations {
    private static final String AFFECTED_VERSIONS_NAME_KEY = "issue.field.affectsversions";
    private final RaisedInVersionStatisticsMapper raisedInVersionStatsMapper;

    public AffectedVersionsSystemField(VelocityTemplatingEngine templatingEngine, ApplicationProperties applicationProperties, VersionManager versionManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, RaisedInVersionStatisticsMapper raisedInVersionStatsMapper, VersionHelperBean versionHelperBean, AffectedVersionSearchHandlerFactory searchHandlerFactory, JiraBaseUrls jiraBaseUrls) {
        super("versions", AFFECTED_VERSIONS_NAME_KEY, templatingEngine, applicationProperties, versionManager, permissionManager, authenticationContext, versionHelperBean, searchHandlerFactory, jiraBaseUrls);
        this.raisedInVersionStatsMapper = raisedInVersionStatsMapper;
    }

    public boolean isShown(Issue issue) {
        return true;
    }

    @Override
    protected Collection<Version> getCurrentVersions(Issue issue) {
        return issue.getAffectedVersions();
    }

    @Override
    protected String getArchivedVersionsFieldTitle() {
        return "issue.field.archived.affectsversions";
    }

    @Override
    protected String getArchivedVersionsFieldSearchParam() {
        return "version";
    }

    @Override
    protected boolean getUnreleasedVersionsFirst() {
        return false;
    }

    @Override
    protected void addFieldRequiredErrorMessage(Issue issue, ErrorCollection errorCollection, I18nHelper i18n) {
        if (this.getPossibleVersions(issue.getProjectObject(), false).isEmpty()) {
            errorCollection.addErrorMessage(i18n.getText("createissue.error.versions.required", i18n.getText(this.getNameKey()), issue.getProjectObject().getName()), ErrorCollection.Reason.VALIDATION_FAILED);
        } else {
            errorCollection.addError(this.getId(), i18n.getText("issue.field.required", i18n.getText(this.getNameKey())), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    public String getColumnHeadingKey() {
        return "issue.column.heading.affectsversions";
    }

    public LuceneFieldSorter getSorter() {
        return this.raisedInVersionStatsMapper;
    }

    @Override
    protected String getIssueRelationName() {
        return "IssueVersion";
    }

    @Override
    protected String getChangeItemFieldName() {
        return "Version";
    }

    @Override
    protected String getModifiedWithoutPermissionErrorMessage(I18nHelper i18n) {
        throw new UnsupportedOperationException("Affected Versions field is not protected by permission.");
    }

    @Override
    public Object getDefaultValue(Issue issue) {
        return Collections.EMPTY_LIST;
    }

    public void updateIssue(FieldLayoutItem fieldLayoutItem, MutableIssue issue, Map fieldValueHolder) {
        if (fieldValueHolder.containsKey(this.getId())) {
            Collection affectedVersions = (Collection)this.getValueFromParams(fieldValueHolder);
            issue.setAffectedVersions(affectedVersions);
        }
    }

    public void removeValueFromIssueObject(MutableIssue issue) {
        issue.setAffectedVersions((Collection)Collections.EMPTY_LIST);
    }

    public boolean canRemoveValueFromIssueObject(Issue issue) {
        return true;
    }

    public RestFieldOperationsHandler getRestFieldOperation() {
        return new AffectedVersionsRestFieldOperationsHandler(this.versionManager, this.authenticationContext.getI18nHelper());
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx) {
        return null;
    }
}

