/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comparator;

import com.atlassian.jira.issue.comparator.CustomFieldComparator;
import com.atlassian.jira.issue.fields.CustomField;
import java.util.Comparator;
import org.ofbiz.core.entity.GenericValue;

public class CustomFieldComparators {
    public static Comparator<CustomField> byName() {
        return new NameComparator();
    }

    public static Comparator<GenericValue> byGvName() {
        return new CustomFieldComparator();
    }

    static int compareNames(String name1, String name2) {
        if (name1 == null && name2 == null) {
            return 0;
        }
        if (name1 == null) {
            return -1;
        }
        if (name2 == null) {
            return 1;
        }
        return name1.compareTo(name2);
    }

    private static class NameComparator
    implements Comparator<CustomField> {
        private NameComparator() {
        }

        @Override
        public int compare(CustomField o1, CustomField o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return CustomFieldComparators.compareNames(o1.getName(), o2.getName());
        }
    }
}

