/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.transformer;

import com.atlassian.jira.external.beans.ExternalNodeAssociation;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.transformer.ComponentTransformer;
import org.apache.log4j.Logger;

public class ComponentTransformerImpl
implements ComponentTransformer {
    private static final Logger log = Logger.getLogger(ComponentTransformerImpl.class);

    @Override
    public ExternalNodeAssociation transform(ProjectImportMapper projectImportMapper, ExternalNodeAssociation component) {
        if ("IssueComponent".equals(component.getAssociationType())) {
            String mappedIssueId = projectImportMapper.getIssueMapper().getMappedId(component.getSourceNodeId());
            String mappedComponentId = projectImportMapper.getComponentMapper().getMappedId(component.getSinkNodeId());
            if (mappedIssueId == null) {
                log.error((Object)("Trying to transform an issue component entry which references an old issue id '" + component.getSourceNodeId() + "' which has no mapped value."));
                return null;
            }
            if (mappedComponentId == null) {
                log.warn((Object)("Trying to transform an issue component entry which references an old component with id '" + component.getSinkNodeId() + "' which has no mapped value. The value will be ignored."));
                return null;
            }
            return new ExternalNodeAssociation(mappedIssueId, component.getSourceNodeEntity(), mappedComponentId, component.getSinkNodeEntity(), component.getAssociationType());
        }
        log.warn((Object)("Component transformer unable to transform node association entry of type '" + component.getAssociationType() + "'."));
        return null;
    }
}

