/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.webwork;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.webwork.ActionNotFoundException;
import com.atlassian.jira.config.webwork.actions.ActionConfiguration;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import webwork.action.Action;
import webwork.action.factory.ActionFactory;
import webwork.action.factory.ActionFactoryProxy;

public class LookupAliasActionFactoryProxy
extends ActionFactoryProxy {
    private ConcurrentMap<String, ActionConfiguration.Entry> actionAliases = new ConcurrentHashMap<String, ActionConfiguration.Entry>();

    public LookupAliasActionFactoryProxy(ActionFactory aFactory) {
        super(aFactory);
    }

    public Action getActionImpl(String alias) throws Exception {
        ActionConfiguration.Entry actionCommand = (ActionConfiguration.Entry)this.actionAliases.get(alias);
        if (actionCommand == null) {
            actionCommand = this.getActionConfiguration().getActionCommand(alias);
            if (actionCommand == null) {
                throw new ActionNotFoundException(alias);
            }
            this.actionAliases.putIfAbsent(alias, actionCommand);
        }
        this.authorise(actionCommand);
        return this.getNextFactory().getActionImpl(actionCommand.toActionFactoryString());
    }

    private void authorise(ActionConfiguration.Entry actionCommand) {
        for (Integer permission : actionCommand.getPermissionsRequired()) {
            if (this.getPermissionManager().hasPermission(permission.intValue(), this.getJiraAuthenticationContext().getLoggedInUser())) continue;
            throw new UnauthorisedActionException();
        }
    }

    private PermissionManager getPermissionManager() {
        return (PermissionManager)ComponentAccessor.getComponent(PermissionManager.class);
    }

    private JiraAuthenticationContext getJiraAuthenticationContext() {
        return (JiraAuthenticationContext)ComponentAccessor.getComponent(JiraAuthenticationContext.class);
    }

    private ActionConfiguration getActionConfiguration() {
        return (ActionConfiguration)ComponentAccessor.getComponent(ActionConfiguration.class);
    }

    public void flushCaches() {
        this.getNextFactory().flushCaches();
        this.actionAliases.clear();
    }

    public class UnauthorisedActionException
    extends RuntimeException {
        UnauthorisedActionException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

