/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.Chart;
import com.atlassian.jira.charts.PieSegmentWrapper;
import com.atlassian.jira.charts.jfreechart.ChartHelper;
import com.atlassian.jira.charts.jfreechart.PieChartGenerator;
import com.atlassian.jira.charts.jfreechart.util.PieDatasetUtil;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.util.RedundantClausesQueryOptimizer;
import com.atlassian.jira.issue.statistics.FilterStatisticsValuesGenerator;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

class PieChart {
    private static final Logger log = Logger.getLogger(PieChart.class);
    private final ConstantsManager constantsManager;
    private final CustomFieldManager customFieldManager;
    private final SearchService searchService;
    private final ApplicationProperties applicationProperties;

    public PieChart(ConstantsManager constantsManager, CustomFieldManager customFieldManager, SearchService searchService, ApplicationProperties applicationProperties) {
        this.constantsManager = constantsManager;
        this.customFieldManager = customFieldManager;
        this.searchService = searchService;
        this.applicationProperties = applicationProperties;
    }

    public Chart generateChart(final User remoteUser, SearchRequest searchRequest, String statisticType, int width, int height) {
        Assertions.notNull((String)"searchRequest", (Object)searchRequest);
        Assertions.notNull((String)"statisticType", (Object)statisticType);
        final I18nBean i18nBean = this.getI18nBean(remoteUser);
        try {
            log.debug((Object)"DataCollector.populatePieChart: Cloning the SearchRequest.");
            final SearchRequest clonedSearchRequest = new SearchRequest(searchRequest.getQuery());
            StatisticAccessorBean statBean = new StatisticAccessorBean(remoteUser, clonedSearchRequest);
            StatisticMapWrapper statWrapper = statBean.getAllFilterBy(statisticType);
            final StatisticsMapper statMapper = statBean.getMapper(statisticType);
            log.debug((Object)"DataCollector.populatePieChart: Creating initial PieDataset.");
            DefaultPieDataset dataset = new DefaultPieDataset();
            long numIssues = statWrapper.getTotalCount();
            for (Object o : statWrapper.entrySet()) {
                Map.Entry statistic = (Map.Entry)o;
                Object key = statistic.getKey();
                PieSegmentWrapper pieSegmentWrapper = new PieSegmentWrapper(key, (I18nHelper)i18nBean, statisticType, this.constantsManager, this.customFieldManager);
                Number number = (Number)statistic.getValue();
                dataset.setValue((Comparable)pieSegmentWrapper, number);
            }
            if (statWrapper.getIrrelevantCount() > 0) {
                PieSegmentWrapper pieSegmentWrapper = new PieSegmentWrapper(FilterStatisticsValuesGenerator.IRRELEVANT, (I18nHelper)i18nBean, statisticType, this.constantsManager, this.customFieldManager);
                Integer number = statWrapper.getIrrelevantCount();
                dataset.setValue((Comparable)pieSegmentWrapper, (Number)number);
            }
            if (numIssues == 0L) {
                height = 35;
            }
            log.debug((Object)"DataCollector.populatePieChart: Processing the PieDataset.");
            PieDataset sortedDataset = PieDatasetUtil.createSortedPieDataset((PieDataset)dataset);
            PieDataset consolidatedDataset = PieDatasetUtil.createConsolidatedSortedPieDataset((PieDataset)sortedDataset, (Comparable)((Object)"Other"), (boolean)false, (double)0.02, (int)10);
            DefaultCategoryDataset completeDataset = new DefaultCategoryDataset();
            for (Comparable key : sortedDataset.getKeys()) {
                Number value = sortedDataset.getValue(key);
                completeDataset.addValue(value, (Comparable)((Object)i18nBean.getText("common.concepts.issues")), key);
                completeDataset.addValue((double)((long)(100 * value.intValue()) / numIssues), (Comparable)((Object)"%"), key);
            }
            log.debug((Object)"DataCollector.populatePieChart: Generate the ChartHelper.");
            ChartHelper helper = new PieChartGenerator(consolidatedDataset, (I18nHelper)i18nBean).generateChart();
            log.debug((Object)"DataCollector.populatePieChart: ChartHelper generated. Add Tooltips and URL Generators.");
            JFreeChart chart = helper.getChart();
            PiePlot plot = (PiePlot)chart.getPlot();
            final long numIssues1 = numIssues;
            plot.setToolTipGenerator(new PieToolTipGenerator(){

                public String generateToolTip(PieDataset dataset, Comparable key) {
                    Number number = dataset.getValue(key);
                    return StringEscapeUtils.escapeHtml((String)key.toString()) + ": " + number + " " + i18nBean.getText("datacollector.tooltip.issues") + " (" + (long)(100 * number.intValue()) / numIssues1 + "%)";
                }
            });
            final VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext();
            plot.setURLGenerator(new PieURLGenerator(){

                public String generateURL(PieDataset dataset, Comparable key, int section) {
                    if (key instanceof PieSegmentWrapper && ((PieSegmentWrapper)key).isGenerateUrl()) {
                        QueryImpl query;
                        SearchRequest searchUrlSuffix = statMapper.getSearchUrlSuffix(((PieSegmentWrapper)key).getKey(), clonedSearchRequest);
                        if (searchUrlSuffix == null) {
                            query = new QueryImpl();
                        } else {
                            RedundantClausesQueryOptimizer optimizer = new RedundantClausesQueryOptimizer();
                            query = optimizer.optimizeQuery(searchUrlSuffix.getQuery());
                        }
                        return velocityRequestContext.getCanonicalBaseUrl() + "/secure/IssueNavigator.jspa?reset=true" + PieChart.this.searchService.getQueryString(remoteUser, (Query)query);
                    }
                    return null;
                }
            });
            CategoryURLGenerator completeUrlGenerator = new CategoryURLGenerator(){

                public String generateURL(CategoryDataset categoryDataset, int row, int col) {
                    Comparable key = categoryDataset.getColumnKey(col);
                    if (key instanceof PieSegmentWrapper) {
                        SearchRequest searchUrlSuffix = statMapper.getSearchUrlSuffix(((PieSegmentWrapper)key).getKey(), clonedSearchRequest);
                        return velocityRequestContext.getCanonicalBaseUrl() + "/secure/IssueNavigator.jspa?reset=true" + PieChart.this.searchService.getQueryString(remoteUser, (Query)(searchUrlSuffix == null ? new QueryImpl() : searchUrlSuffix.getQuery()));
                    }
                    return null;
                }
            };
            log.debug((Object)"DataCollector.populatePieChart: Have the ChartHelper generate the image.");
            helper.generate(width, height);
            log.debug((Object)"DataCollector.populatePieChart: ChartHelper finished generating.");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("chart", helper.getLocation());
            params.put("chartDataset", consolidatedDataset);
            params.put("completeDataset", completeDataset);
            params.put("completeDatasetUrlGenerator", completeUrlGenerator);
            params.put("numIssues", numIssues);
            params.put("statisticType", statisticType);
            params.put("statisticTypeI18nName", this.getStatisticsTypeI18nName(i18nBean, statisticType));
            params.put("imagemap_html", helper.getImageMap());
            params.put("imagemapName", helper.getImageMapName());
            params.put("width", width);
            params.put("height", height);
            return new Chart(helper.getLocation(), helper.getImageMap(), helper.getImageMapName(), params);
        }
        catch (SearchException e) {
            throw new RuntimeException("Error generating pie chart", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating pie chart", e);
        }
    }

    String getStatisticsTypeI18nName(I18nHelper i18nBean, String statisticType) {
        if (statisticType.startsWith("customfield_")) {
            CustomField customField = this.customFieldManager.getCustomFieldObject(statisticType);
            if (customField == null) {
                throw new RuntimeException("No custom field with id '" + statisticType + "'");
            }
            if (customField.getCustomFieldSearcher() instanceof CustomFieldStattable) {
                return customField.getName();
            }
            return null;
        }
        return i18nBean.getText("gadget.filterstats.field.statistictype." + statisticType.toLowerCase());
    }

    private I18nBean getI18nBean(User remoteUser) {
        return new I18nBean(remoteUser);
    }
}

