/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.workflow;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.workflow.WorkflowSchemeService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import javax.annotation.Nonnull;

public class DefaultWorkflowSchemeService
implements WorkflowSchemeService {
    private final PermissionManager permissionManager;
    private final I18nHelper.BeanFactory i18Factory;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final WorkflowManager workflowManager;

    public DefaultWorkflowSchemeService(PermissionManager permissionManager, I18nHelper.BeanFactory i18Factory, WorkflowSchemeManager workflowSchemeManager, WorkflowManager workflowManager) {
        this.permissionManager = permissionManager;
        this.i18Factory = i18Factory;
        this.workflowSchemeManager = workflowSchemeManager;
        this.workflowManager = workflowManager;
    }

    public ServiceOutcome<DraftWorkflowScheme> createDraft(ApplicationUser creator, long parentId) {
        if (!this.hasAdminPermission(creator)) {
            return this.getError(creator, "admin.workflowschemes.service.error.no.admin.permission");
        }
        ServiceOutcome<AssignableWorkflowScheme> parentSchemeOutcome = this.getWorkflowScheme(creator, parentId);
        if (!parentSchemeOutcome.isValid()) {
            return ServiceOutcomeImpl.from(parentSchemeOutcome.getErrorCollection(), null);
        }
        AssignableWorkflowScheme workflowScheme = (AssignableWorkflowScheme)parentSchemeOutcome.getReturnedValue();
        if (!this.workflowSchemeManager.isActive((WorkflowScheme)workflowScheme)) {
            return this.getError(creator, "admin.workflowschemes.service.error.not.active");
        }
        if (this.workflowSchemeManager.hasDraft(workflowScheme)) {
            return this.getError(creator, "admin.workflowschemes.service.error.has.draft");
        }
        DraftWorkflowScheme draft = this.workflowSchemeManager.createDraftOf(creator, workflowScheme);
        return ServiceOutcomeImpl.ok(draft);
    }

    public ServiceOutcome<AssignableWorkflowScheme> getWorkflowScheme(ApplicationUser user, long id) {
        AssignableWorkflowScheme workflowScheme = this.workflowSchemeManager.getWorkflowSchemeObj(id);
        if (workflowScheme == null) {
            return this.getError(user, "admin.workflowschemes.service.error.does.not.exist");
        }
        return ServiceOutcomeImpl.ok(workflowScheme);
    }

    public ServiceOutcome<DraftWorkflowScheme> getDraftWorkflowScheme(ApplicationUser user, @Nonnull AssignableWorkflowScheme parentScheme) {
        Assertions.notNull((String)"scheme", (Object)parentScheme);
        return ServiceOutcomeImpl.ok(!parentScheme.isDefault() ? this.workflowSchemeManager.getDraftForParent(parentScheme) : null);
    }

    public ServiceOutcome<DraftWorkflowScheme> getDraftWorkflowSchemeNotNull(ApplicationUser user, @Nonnull AssignableWorkflowScheme parentScheme) {
        ServiceOutcome<DraftWorkflowScheme> result = this.getDraftWorkflowScheme(user, parentScheme);
        if (!result.isValid() || result.getReturnedValue() != null) {
            return result;
        }
        return this.getError(user, "admin.workflowschemes.service.error.no.draft");
    }

    public ServiceOutcome<Void> deleteWorkflowScheme(ApplicationUser user, @Nonnull WorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        if (!this.hasAdminPermission(user)) {
            return this.getError(user, "admin.workflowschemes.service.error.no.admin.permission");
        }
        if (scheme.isDefault()) {
            return this.getError(user, "admin.workflowschemes.service.error.cant.delete.default");
        }
        if (this.isActive(scheme)) {
            return this.getError(user, "admin.workflowschemes.service.error.delete.active");
        }
        if (!this.workflowSchemeManager.deleteWorkflowScheme(scheme)) {
            return this.getError(user, "admin.workflowschemes.service.error.delete.error");
        }
        return ServiceOutcomeImpl.ok(null);
    }

    public boolean isActive(WorkflowScheme workflowScheme) {
        return this.workflowSchemeManager.isActive((WorkflowScheme)Assertions.notNull((String)"workflowScheme", (Object)workflowScheme));
    }

    public ServiceOutcome<AssignableWorkflowScheme> getSchemeForProject(ApplicationUser user, @Nonnull Project project) {
        if (!this.hasPermissionToEditProject(user, project)) {
            return this.getError(user, "admin.workflowschemes.service.error.no.permission.project");
        }
        return ServiceOutcomeImpl.ok(this.workflowSchemeManager.getWorkflowSchemeObj(project));
    }

    public ServiceOutcome<DraftWorkflowScheme> updateWorkflowScheme(ApplicationUser user, @Nonnull DraftWorkflowScheme scheme) {
        Assertions.notNull((String)"scheme", (Object)scheme);
        if (!this.hasAdminPermission(user)) {
            return this.getError(user, "admin.workflowschemes.service.error.no.admin.permission");
        }
        for (String workflowName : scheme.getMappings().values()) {
            if (this.workflowManager.getWorkflow(workflowName) != null) continue;
            return this.getError(user, "admin.workflowschemes.service.error.bad.workflow", workflowName);
        }
        return ServiceOutcomeImpl.ok(this.workflowSchemeManager.updateDraftWorkflowScheme(user, scheme));
    }

    public int getUsageCount(@Nonnull AssignableWorkflowScheme assignableWorkflowScheme) {
        return this.workflowSchemeManager.getProjectsUsing(assignableWorkflowScheme).size();
    }

    public boolean isUsingDefaultScheme(@Nonnull Project project) {
        return this.workflowSchemeManager.isUsingDefaultScheme(project);
    }

    boolean hasPermissionToEditProject(ApplicationUser user, Project project) {
        return ProjectAction.EDIT_PROJECT_CONFIG.hasPermission(this.permissionManager, (User)user, project);
    }

    private <T> ServiceOutcome<T> getError(ApplicationUser user, String key) {
        return ServiceOutcomeImpl.error(this.i18Factory.getInstance((User)user).getText(key));
    }

    private <T> ServiceOutcome<T> getError(ApplicationUser user, String key, String arg) {
        return ServiceOutcomeImpl.error(this.i18Factory.getInstance((User)user).getText(key, arg));
    }

    private boolean hasAdminPermission(ApplicationUser user) {
        return this.permissionManager.hasPermission(0, (User)user);
    }
}

