/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.function.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.workflow.function.issue.AbstractJiraFunctionProvider;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class AssignToLeadFunction
extends AbstractJiraFunctionProvider {
    private static final Logger log = Logger.getLogger(AssignToLeadFunction.class);

    public void execute(Map transientVars, Map args, PropertySet ps) {
        MutableIssue issue = this.getIssue(transientVars);
        String leadName = null;
        User lead = null;
        boolean componentLead = false;
        if (issue.getComponents() != null && issue.getComponents().size() > 0) {
            componentLead = true;
            GenericValue firstComponent = (GenericValue)issue.getComponents().iterator().next();
            leadName = firstComponent.getString("lead");
        }
        if (leadName == null) {
            lead = issue.getProjectObject().getLead();
            String string = leadName = lead != null ? lead.getName() : null;
        }
        if (leadName == null) {
            return;
        }
        if (lead == null && (lead = this.getLead(leadName)) == null) {
            log.error((Object)((componentLead ? "Component" : "Project") + " lead '" + leadName + "' in project " + issue.getProjectObject().getName() + " does not exist"));
            return;
        }
        log.info((Object)("Automatically setting assignee to lead developer " + leadName));
        issue.setAssignee(lead);
        if (issue.isCreated()) {
            issue.store();
        }
    }

    User getLead(String userName) {
        return UserUtils.getUser((String)userName);
    }
}

