/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps.instrumentation;

import com.atlassian.instrumentation.Gauge;
import com.atlassian.instrumentation.operations.OpTimer;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.web.filters.steps.FilterCallContext;
import com.atlassian.jira.web.filters.steps.FilterStep;

public class InstrumentationStep
implements FilterStep {
    private final Gauge concurrentUsersGauge = Instrumentation.pullGauge(InstrumentationName.CONCURRENT_USERS);
    private OpTimer requestTimer;

    @Override
    public FilterCallContext beforeDoFilter(FilterCallContext callContext) {
        this.requestTimer = Instrumentation.pullTimer(InstrumentationName.WEB_REQUESTS);
        this.concurrentUsersGauge.incrementAndGet();
        return callContext;
    }

    @Override
    public FilterCallContext finallyAfterDoFilter(FilterCallContext callContext) {
        this.requestTimer.end();
        this.concurrentUsersGauge.decrementAndGet();
        return callContext;
    }
}

