/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.subtask;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bean.SubTaskBean;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayoutItem;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraWebUtils;
import com.atlassian.jira.web.component.SimpleColumnLayoutItem;
import com.atlassian.jira.web.component.subtask.ActionsAndOperationsColumnLayoutItem;
import com.atlassian.jira.web.component.subtask.SubTaskReorderColumnLayoutItem;
import com.atlassian.velocity.VelocityManager;
import com.opensymphony.util.TextUtils;
import java.util.Map;

public class ColumnLayoutItemFactory {
    private final PermissionManager permissionManager;
    private final VelocityManager velocityManager;
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext authenticationContext;
    private final XsrfTokenGenerator xsrfTokenGenerator;
    private final I18nHelper.BeanFactory beanFactory;

    public ColumnLayoutItemFactory(PermissionManager permissionManager, VelocityManager velocityManager, ApplicationProperties applicationProperties, JiraAuthenticationContext authenticationContext, XsrfTokenGenerator xsrfTokenGenerator, I18nHelper.BeanFactory beanFactory) {
        this.permissionManager = permissionManager;
        this.velocityManager = velocityManager;
        this.applicationProperties = applicationProperties;
        this.authenticationContext = authenticationContext;
        this.xsrfTokenGenerator = xsrfTokenGenerator;
        this.beanFactory = beanFactory;
    }

    public ColumnLayoutItem getSubTaskReorderColumn(User user, Issue parentIssue, SubTaskBean subTaskBean, String subTaskView) {
        I18nHelper i18n = this.beanFactory.getInstance(user);
        return new SubTaskReorderColumnLayoutItem(this.permissionManager, subTaskBean, subTaskView, parentIssue, user, i18n);
    }

    public ColumnLayoutItem getActionsAndOperationsColumn() {
        return new ActionsAndOperationsColumnLayoutItem(this.velocityManager, this.applicationProperties, this.authenticationContext, this.xsrfTokenGenerator);
    }

    public ColumnLayoutItem getSubTaskDisplaySequenceColumn() {
        return new SimpleColumnLayoutItem(){
            int displaySequence = 0;

            @Override
            public String getHtml(Map displayParams, Issue issue) {
                if (issue.getResolutionObject() != null) {
                    return "<div style=\"padding: 0 18px 0 0; background-image: url( '../images/icons/accept.png' ); background-repeat: no-repeat; background-position: 100% 50%;\">" + ++this.displaySequence + ".</div>";
                }
                return "" + ++this.displaySequence + ".";
            }

            @Override
            protected String getColumnCssClass() {
                return "stsequence";
            }
        };
    }

    public ColumnLayoutItem getSubTaskSimpleSummaryColumn() {
        return new SimpleColumnLayoutItem(){
            final int displaySequence = 0;
            final String contextPath = JiraWebUtils.getHttpRequest().getContextPath();

            @Override
            public String getHtml(Map displayParams, Issue issue) {
                StringBuilder html = new StringBuilder();
                html.append("<a href='").append(this.contextPath).append("/browse/").append(issue.getKey()).append("'>").append(TextUtils.htmlEncode((String)issue.getSummary())).append("</a>");
                return html.toString();
            }

            @Override
            protected String getColumnCssClass() {
                return "stsummary";
            }
        };
    }
}

