/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.schemepicker;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.web.component.AbstractWebComponent;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;

public class SchemePickerWebComponent
extends AbstractWebComponent {
    private final JiraAuthenticationContext authenticationContext = ComponentManager.getComponentInstanceOfType(JiraAuthenticationContext.class);
    private final Map schemesByType;
    private final Map schemeTypes;
    private final String selectedSchemeType;
    private final String[] selectedSchemeIds;

    public SchemePickerWebComponent(Map schemesByType, Map schemeTypes, String defaultSchemeType, String[] selectedSchemeIds) {
        super(ManagerFactory.getVelocityManager(), ManagerFactory.getApplicationProperties());
        this.schemesByType = schemesByType;
        this.schemeTypes = schemeTypes;
        this.selectedSchemeType = defaultSchemeType;
        this.selectedSchemeIds = selectedSchemeIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHtml(String actionNameFori18n) {
        try {
            UtilTimerStack.push((String)"SchemePickerHtml");
            I18nHelper i18n = this.authenticationContext.getI18nHelper();
            Map startingParams = EasyMap.build((Object)"i18n", (Object)i18n, (Object)"schemePickerWebComponent", (Object)this, (Object)"windowName", (Object)"SchemePicker");
            Map<String, Object> params = JiraVelocityUtils.getDefaultVelocityParams(startingParams, this.authenticationContext);
            String string = this.getHtml("templates/jira/schemes/schemepicker/schemepickertable.vm", params);
            return string;
        }
        finally {
            UtilTimerStack.pop((String)"SchemePickerHtml");
        }
    }

    public static Collection getSelectedSchemeIds(Map params) {
        String[] selectedSchemeParams;
        List<Object> selectedSchemes = new ArrayList();
        if (params != null && (selectedSchemeParams = (String[])params.get("selectedSchemeIds")) != null) {
            selectedSchemes = Arrays.asList(selectedSchemeParams);
        }
        return selectedSchemes;
    }

    public static String getSchemeType(Map params) {
        String[] schemeTypeParam;
        String schemeType = null;
        if (params != null && (schemeTypeParam = (String[])params.get("selectedSchemeType")) != null) {
            schemeType = schemeTypeParam[0];
        }
        return schemeType;
    }

    public Map getSchemes() throws GenericEntityException {
        return this.schemesByType;
    }

    public Map getSchemeTypes() {
        return this.schemeTypes;
    }

    public String getSelectedSchemeType() {
        return this.selectedSchemeType;
    }

    public boolean isSchemeSelected(Long schemeId) {
        if (schemeId == null || this.selectedSchemeIds == null) {
            return false;
        }
        for (String selectedSchemeId : this.selectedSchemeIds) {
            if (!selectedSchemeId.equals(schemeId.toString())) continue;
            return true;
        }
        return false;
    }
}

