/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component;

import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.StringUtils;

public class IssueConstantWebComponent {
    private String baseUrl;

    public IssueConstantWebComponent(VelocityRequestContextFactory velocityRequestContextFactory) {
        VelocityRequestContext requestContext = velocityRequestContextFactory.getJiraVelocityRequestContext();
        this.baseUrl = requestContext.getBaseUrl();
    }

    public IssueConstantWebComponent(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getHtml(IssueConstant issueConstant, String imgClass) {
        String iconUrl = issueConstant.getIconUrl();
        if (StringUtils.isNotBlank((String)iconUrl)) {
            String fullIconUrl = iconUrl.startsWith("http://") || iconUrl.startsWith("https://") ? issueConstant.getIconUrlHtml() : this.baseUrl + issueConstant.getIconUrlHtml();
            String title = StringUtils.isNotBlank((String)issueConstant.getDescTranslation()) ? TextUtils.htmlEncode((String)issueConstant.getNameTranslation(), (boolean)false) + " - " + TextUtils.htmlEncode((String)issueConstant.getDescTranslation(), (boolean)false) : TextUtils.htmlEncode((String)issueConstant.getNameTranslation(), (boolean)false);
            String fullImgClass = StringUtils.isBlank((String)imgClass) ? "" : "class=\"" + imgClass + "\"";
            return "<img " + fullImgClass + " alt=\"" + TextUtils.htmlEncode((String)issueConstant.getNameTranslation(), (boolean)false) + "\" height=\"16\" src=\"" + fullIconUrl + "\" title=\"" + title + "\" width=\"16\" />";
        }
        return "";
    }

    public String getHtml(IssueConstant issueConstant) {
        return this.getHtml(issueConstant, null);
    }
}

