/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.web.component.AbstractWebComponent;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.velocity.VelocityManager;
import java.util.Map;

public class CreateIssueWebComponent
extends AbstractWebComponent {
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;

    public CreateIssueWebComponent(VelocityManager velocityManager, ApplicationProperties applicationProperties, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        super(velocityManager, applicationProperties);
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
    }

    public String getHtml(Project project) {
        User user = this.authenticationContext.getUser();
        if (!this.show(project, user)) {
            return "";
        }
        WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
        webResourceManager.requireResource("jira.webresources:jira-global");
        Map<String, Object> velocityParams = JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext);
        return this.getHtml("templates/jira/multipicker/pickertable.vm", velocityParams);
    }

    boolean show(Project project, User user) {
        return project != null && this.permissionManager.hasPermission(11, project, user);
    }
}

