/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.velocity.VelocityManager;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public class AbstractWebComponent {
    private static final Logger log = Logger.getLogger(AbstractWebComponent.class);
    protected final VelocityManager velocityManager;
    protected final ApplicationProperties applicationProperties;

    public AbstractWebComponent(VelocityManager velocityManager, ApplicationProperties applicationProperties) {
        this.velocityManager = velocityManager;
        this.applicationProperties = applicationProperties;
    }

    protected String getHtml(String resourceName, Map<String, Object> startingParams) {
        if (TextUtils.stringSet((String)resourceName)) {
            try {
                return this.velocityManager.getEncodedBody(resourceName, "", this.applicationProperties.getEncoding(), startingParams);
            }
            catch (VelocityException e) {
                log.error((Object)("Error while rendering velocity template for '" + resourceName + "'."), (Throwable)e);
            }
        }
        return "";
    }
}

