/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.PercentageGraphModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class TimeTrackingGraphBean {
    private PercentageGraphModel timeSpentGraph;
    private PercentageGraphModel originalEstimateGraph;
    private PercentageGraphModel remainingEstimateGraph;
    private PercentageGraphModel progressGraph;
    private PercentageGraphModel originalProgressGraph;
    private final I18nHelper i18nHelper;
    private final String timeSpentStr;
    private final Tooltip timeSpentTooltip;
    private final String originalEstimateStr;
    private final Tooltip originalEstimateTooltip;
    private final String remainingEstimateStr;
    private final Tooltip remainingEstimateTooltip;
    private final long timeSpent;
    private final long originalEstimate;
    private final long remainingEstimate;
    private final long totalTime;

    public TimeTrackingGraphBean(Parameters params) {
        Assertions.notNull((String)"params", (Object)params);
        this.i18nHelper = params.getI18nHelper();
        this.originalEstimate = TimeTrackingGraphBean.nullOrNegative(params.getOriginalEstimate());
        this.originalEstimateStr = params.getOriginalEstimateStr();
        this.originalEstimateTooltip = TimeTrackingGraphBean.createTooltip(this.i18nHelper, "common.concepts.original.estimate", params.getOriginalEstimateTooltip(), params.getOriginalEstimateStr());
        this.remainingEstimate = TimeTrackingGraphBean.nullOrNegative(params.getRemainingEstimate());
        this.remainingEstimateStr = params.getRemainingEstimateStr();
        this.remainingEstimateTooltip = TimeTrackingGraphBean.createTooltip(this.i18nHelper, "common.concepts.remaining.estimate", params.getRemainingEstimateTooltip(), params.getRemainingEstimateStr());
        this.timeSpent = TimeTrackingGraphBean.nullOrNegative(params.getTimeSpent());
        this.timeSpentStr = params.getTimeSpentStr();
        this.timeSpentTooltip = TimeTrackingGraphBean.createTooltip(this.i18nHelper, "common.concepts.time.spent", params.getTimeSpentTooltip(), params.getTimeSpentStr());
        this.totalTime = this.timeSpent + this.remainingEstimate;
    }

    public boolean hasData() {
        return !this.getOriginalProgressGraph().isTotalZero() && !this.getTimeSpentGraph().isTotalZero() && !this.getRemainingEstimateGraph().isTotalZero();
    }

    private PercentageGraphModel createRemainingEstimateGraph() {
        PercentageGraphModel gm = new PercentageGraphModel();
        gm.addRow("#cccccc", this.timeSpent, this.remainingEstimate == 0L ? this.getRemainingEstimateTooltip() : this.getTimeSpentTooltip());
        gm.addRow("#ec8e00", this.remainingEstimate, this.getRemainingEstimateTooltip());
        if (this.originalEstimate > this.totalTime) {
            gm.addRow("transparent", this.originalEstimate - this.totalTime, "");
        }
        return gm;
    }

    private PercentageGraphModel createOriginalEstimateGraph(String bgColour) {
        String tooltipToUse = this.originalEstimateTooltip.geText();
        PercentageGraphModel gm = new PercentageGraphModel();
        gm.addRow("#89afd7", this.originalEstimate, tooltipToUse);
        if (this.originalEstimate < this.totalTime) {
            gm.addRow(bgColour, this.totalTime - this.originalEstimate, tooltipToUse);
        }
        return gm;
    }

    private PercentageGraphModel createTimeSpentGraph() {
        PercentageGraphModel gm = new PercentageGraphModel();
        gm.addRow("#51a825", this.timeSpent, this.getTimeSpentTooltip());
        gm.addRow("#cccccc", this.remainingEstimate, this.timeSpent == 0L ? this.getTimeSpentTooltip() : this.getRemainingEstimateTooltip());
        if (this.originalEstimate > this.totalTime) {
            gm.addRow("transparent", this.originalEstimate - this.totalTime, this.i18nHelper.getText("common.concepts.time.not.required"));
        }
        return gm;
    }

    private PercentageGraphModel createProgressGraph() {
        PercentageGraphModel gm = new PercentageGraphModel();
        gm.addRow("#51a825", this.timeSpent, this.getTimeSpentTooltip());
        gm.addRow("#ec8e00", this.remainingEstimate, this.getRemainingEstimateTooltip());
        if (this.originalEstimate > this.totalTime) {
            gm.addRow("transparent", this.originalEstimate - this.totalTime, this.i18nHelper.getText("common.concepts.time.not.required"));
        }
        return gm;
    }

    public PercentageGraphModel getTimeSpentGraph() {
        if (this.timeSpentGraph == null) {
            this.timeSpentGraph = this.createTimeSpentGraph();
        }
        return this.timeSpentGraph;
    }

    public PercentageGraphModel getOriginalEstimateGraph() {
        if (this.originalEstimateGraph == null) {
            this.originalEstimateGraph = this.createOriginalEstimateGraph("#cccccc");
        }
        return this.originalEstimateGraph;
    }

    public PercentageGraphModel getRemainingEstimateGraph() {
        if (this.remainingEstimateGraph == null) {
            this.remainingEstimateGraph = this.createRemainingEstimateGraph();
        }
        return this.remainingEstimateGraph;
    }

    public PercentageGraphModel getOriginalProgressGraph() {
        if (this.originalProgressGraph == null) {
            this.originalProgressGraph = this.createOriginalEstimateGraph("transparent");
        }
        return this.originalProgressGraph;
    }

    public PercentageGraphModel getProgressGraph() {
        if (this.progressGraph == null) {
            this.progressGraph = this.createProgressGraph();
        }
        return this.progressGraph;
    }

    public long getTimeSpent() {
        return this.timeSpent;
    }

    public long getOriginalEstimate() {
        return this.originalEstimate;
    }

    public long getRemainingEstimate() {
        return this.remainingEstimate;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public String getTimeSpentStr() {
        return this.timeSpentStr;
    }

    public String getOriginalEstimateStr() {
        return this.originalEstimateStr;
    }

    public String getRemainingEstimateStr() {
        return this.remainingEstimateStr;
    }

    public String getTimeSpentTooltip() {
        return this.timeSpentTooltip.geText();
    }

    public String getOriginalEstimateTooltip() {
        return this.originalEstimateTooltip.geText();
    }

    public String getRemainingEstimateTooltip() {
        return this.remainingEstimateTooltip.geText();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static Tooltip createTooltip(I18nHelper helper, String key, String tooltip, String backup) {
        String actualTip;
        boolean known = true;
        if (StringUtils.isBlank((String)tooltip)) {
            if (StringUtils.isBlank((String)backup)) {
                actualTip = helper.getText("viewissue.timetracking.unknown");
                known = false;
            } else {
                actualTip = backup;
            }
        } else {
            actualTip = tooltip;
        }
        return new Tooltip(String.format("%s - %s", helper.getText(key), actualTip), known);
    }

    private static long nullOrNegative(Long value) {
        return value == null ? 0L : (value < 0L ? 0L : value);
    }

    public static class Parameters {
        private final I18nHelper helper;
        private Long timeSpent;
        private String timeSpentStr;
        private String timeSpentTooltip;
        private Long originalEstimate;
        private String originalEstimateStr;
        private String originalEstimateTooltip;
        private Long remainingEstimate;
        private String remainingEstimateStr;
        private String remainingEstimateTooltip;

        public Parameters(I18nHelper i18nBean) {
            this.helper = (I18nHelper)Assertions.notNull((String)"i18nBean", (Object)i18nBean);
        }

        public I18nHelper getI18nHelper() {
            return this.helper;
        }

        public Long getTimeSpent() {
            return this.timeSpent;
        }

        public String getTimeSpentStr() {
            return this.timeSpentStr;
        }

        public Long getOriginalEstimate() {
            return this.originalEstimate;
        }

        public String getOriginalEstimateStr() {
            return this.originalEstimateStr;
        }

        public Long getRemainingEstimate() {
            return this.remainingEstimate;
        }

        public String getRemainingEstimateStr() {
            return this.remainingEstimateStr;
        }

        public Parameters setTimeSpent(Long timeSpent) {
            this.timeSpent = timeSpent;
            return this;
        }

        public Parameters setTimeSpentStr(String timeSpentStr) {
            this.timeSpentStr = timeSpentStr;
            return this;
        }

        public Parameters setOriginalEstimate(Long originalEstimate) {
            this.originalEstimate = originalEstimate;
            return this;
        }

        public Parameters setOriginalEstimateStr(String originalEstimateStr) {
            this.originalEstimateStr = originalEstimateStr;
            return this;
        }

        public Parameters setRemainingEstimate(Long remainingEstimate) {
            this.remainingEstimate = remainingEstimate;
            return this;
        }

        public Parameters setRemainingEstimateStr(String remainingEstimateStr) {
            this.remainingEstimateStr = remainingEstimateStr;
            return this;
        }

        public String getTimeSpentTooltip() {
            return this.timeSpentTooltip;
        }

        public Parameters setTimeSpentTooltip(String timeSpentTooltip) {
            this.timeSpentTooltip = timeSpentTooltip;
            return this;
        }

        public String getOriginalEstimateTooltip() {
            return this.originalEstimateTooltip;
        }

        public Parameters setOriginalEstimateTooltip(String originalEstimateTooltip) {
            this.originalEstimateTooltip = originalEstimateTooltip;
            return this;
        }

        public String getRemainingEstimateTooltip() {
            return this.remainingEstimateTooltip;
        }

        public Parameters setRemainingEstimateTooltip(String remainingEstimateTooltip) {
            this.remainingEstimateTooltip = remainingEstimateTooltip;
            return this;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    private static class Tooltip {
        private final String text;
        private final boolean isKnown;

        private Tooltip(String text, boolean known) {
            this.text = text;
            this.isKnown = known;
        }

        public String geText() {
            return this.text;
        }

        public boolean isKnown() {
            return this.isKnown;
        }
    }

    static final class Colors {
        static final String DEFAULT_BACKGROUND = "#cccccc";
        static final String REMAINING_TIME = "#ec8e00";
        static final String ORIGINAL_ESTIMATE = "#89afd7";
        static final String TIME_SPENT = "#51a825";
        static final String LEFT_OVER = "transparent";

        Colors() {
        }
    }
}

