/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.language.LanguageModuleDescriptor;
import com.atlassian.jira.plugin.util.InvolvedPluginsTracker;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.LocaleParser;
import com.atlassian.jira.util.i18n.I18nTranslationMode;
import com.atlassian.jira.web.bean.BackingI18n;
import com.atlassian.jira.web.util.JiraLocaleUtils;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.event.events.PluginRefreshedEvent;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class I18nBean
implements I18nHelper {
    private final I18nHelper delegate;

    public static Locale getLocaleFromUser(User user) {
        if (user != null) {
            PropertySet propertySet = I18nBean.getUserPropertyManager().getPropertySet(user);
            if (propertySet == null) {
                return I18nBean.getDefaultLocale();
            }
            String localeStr = propertySet.getString("jira.user.locale");
            if (!StringUtils.isBlank((String)localeStr)) {
                return LocaleParser.parseLocale((String)localeStr);
            }
        }
        return I18nBean.getDefaultLocale();
    }

    private static Locale getDefaultLocale() {
        return ComponentAccessor.getApplicationProperties().getDefaultLocale();
    }

    private static UserPropertyManager getUserPropertyManager() {
        return ManagerFactory.getUserPropertyManager();
    }

    public I18nBean() {
        this.delegate = this.getFactory().getInstance(ComponentAccessor.getApplicationProperties().getDefaultLocale());
    }

    public I18nBean(Locale locale) {
        this.delegate = this.getFactory().getInstance(locale);
    }

    public I18nBean(User user) {
        this(I18nBean.getLocaleFromUser(user));
    }

    public I18nBean(I18nHelper delegate) {
        this.delegate = delegate;
    }

    @Deprecated
    public I18nBean(String localeString) {
        this(LocaleParser.parseLocale((String)localeString));
    }

    protected I18nHelper.BeanFactory getFactory() {
        return ComponentManager.getComponentInstanceOfType(I18nHelper.BeanFactory.class);
    }

    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    public ResourceBundle getDefaultResourceBundle() {
        return this.delegate.getDefaultResourceBundle();
    }

    public Set<String> getKeysForPrefix(String prefix) {
        return this.delegate.getKeysForPrefix(prefix);
    }

    public String getUnescapedText(String key) {
        return this.delegate.getUnescapedText(key);
    }

    public String getText(String key) {
        return this.delegate.getText(key);
    }

    public String getText(String key, String value1) {
        return this.delegate.getText(key, value1);
    }

    public String getText(String key, Object parameters) {
        return this.delegate.getText(key, parameters);
    }

    public String getText(String key, Object value1, Object value2, Object value3) {
        return this.delegate.getText(key, value1, value2, value3);
    }

    public String getText(String key, String value1, String value2) {
        return this.delegate.getText(key, value1, value2);
    }

    public String getText(String key, String value1, String value2, String value3) {
        return this.delegate.getText(key, value1, value2, value3);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4) {
        return this.delegate.getText(key, value1, value2, value3, value4);
    }

    public String getText(String key, String value1, String value2, String value3, String value4) {
        return this.delegate.getText(key, value1, value2, value3, value4);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5) {
        return this.delegate.getText(key, value1, value2, value3, value4, value5);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6) {
        return this.delegate.getText(key, value1, value2, value3, value4, value5, value6);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7) {
        return this.delegate.getText(key, value1, value2, value3, value4, value5, value6, value7);
    }

    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7) {
        return this.delegate.getText(key, value1, value2, value3, value4, value5, value6, value7);
    }

    public String getText(String key, Object value1, Object value2, Object value3, Object value4, Object value5, Object value6, Object value7, Object value8) {
        return this.delegate.getText(key, value1, value2, value3, value4, value5, value6, value7, value8);
    }

    public String getText(String key, String value1, String value2, String value3, String value4, String value5, String value6, String value7, String value8, String value9) {
        return this.delegate.getText(key, value1, value2, value3, value4, value5, value6, value7, value8, value9);
    }

    public static class CachingFactory
    implements I18nHelper.BeanFactory {
        private static final String I18N_RESOURCE_TYPE = "i18n";
        private final Cache<Locale, I18nHelper> cache;
        private final JiraLocaleUtils jiraLocaleUtils;
        private final I18nTranslationMode i18nTranslationMode;
        private final InvolvedPluginsTracker involvedPluginsTracker;
        private static final String CACHE_NAME = "I18nBeans";

        public CachingFactory(CacheFactory factory, EventPublisher eventPublisher, JiraLocaleUtils jiraLocaleUtils, I18nTranslationMode i18nTranslationMode) {
            this.jiraLocaleUtils = jiraLocaleUtils;
            this.i18nTranslationMode = i18nTranslationMode;
            this.involvedPluginsTracker = new InvolvedPluginsTracker();
            this.cache = factory.getCache(CACHE_NAME, Locale.class, I18nHelper.class);
            eventPublisher.register((Object)this);
        }

        @EventListener
        public void pluginModuleDisabled(PluginModuleDisabledEvent event) {
            if (this.involvedPluginsTracker.isPluginInvolved(event.getModule())) {
                this.clearCaches();
            }
        }

        @EventListener
        public void pluginModuleEnabled(PluginModuleEnabledEvent event) {
            if (this.involvedPluginsTracker.isPluginWithModuleDescriptor(event.getModule(), LanguageModuleDescriptor.class) || this.involvedPluginsTracker.isPluginWithResourceType(event.getModule(), I18N_RESOURCE_TYPE)) {
                this.clearCaches();
            }
        }

        @EventListener
        public void pluginRefreshed(PluginRefreshedEvent event) {
            if (this.involvedPluginsTracker.isPluginInvolved(event.getPlugin())) {
                this.clearCaches();
            }
        }

        private void clearCaches() {
            this.involvedPluginsTracker.clear();
            this.cache.removeAll();
            this.jiraLocaleUtils.resetInstalledLocales();
        }

        public I18nHelper getInstance(Locale locale) {
            I18nHelper i18nHelper = (I18nHelper)this.cache.get((Object)locale);
            if (i18nHelper == null) {
                i18nHelper = new BackingI18n(locale, this.i18nTranslationMode, this.involvedPluginsTracker);
                this.cache.put((Object)locale, (Object)i18nHelper);
            }
            return i18nHelper;
        }

        public I18nHelper getInstance(User user) {
            return this.getInstance(I18nBean.getLocaleFromUser(user));
        }

        public String getStateHashCode() {
            return Integer.toString(this.involvedPluginsTracker.hashCode(), 36);
        }
    }

    public static class AccessorFactory
    implements I18nHelper.BeanFactory {
        private final I18nHelper.BeanFactory delegate;

        public AccessorFactory(CachingFactory delegate) {
            this.delegate = delegate;
        }

        public I18nHelper getInstance(Locale locale) {
            return this.delegate.getInstance(locale);
        }

        public I18nHelper getInstance(User user) {
            return this.delegate.getInstance(user);
        }
    }
}

