/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.workflow;

import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueUtilsBean;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.web.action.issue.AbstractViewIssue;
import com.atlassian.jira.web.action.workflow.WorkflowAwareAction;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import com.atlassian.jira.workflow.WorkflowTransitionUtilImpl;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import webwork.action.ActionContext;

public class WorkflowUIDispatcher
extends AbstractViewIssue
implements WorkflowAwareAction {
    public static final String INVALID_ACTION = "invalidworkflowaction";
    private final WorkflowManager workflowManager;
    private final IssueUtilsBean issueUtils;
    private int action;

    public WorkflowUIDispatcher(IssueLinkManager issueLinkManager, SubTaskManager subTaskManager, WorkflowManager workflowManager, IssueUtilsBean issueUtils) {
        super(issueLinkManager, subTaskManager);
        this.workflowManager = workflowManager;
        this.issueUtils = issueUtils;
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        try {
            this.getIssue();
        }
        catch (IssuePermissionException e) {
            return "permissionviolation";
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        if (!this.issueUtils.isValidAction((Issue)this.getIssueObject(), this.action)) {
            return INVALID_ACTION;
        }
        WorkflowTransitionUtil workflowTransitionUtil = JiraUtils.loadComponent(WorkflowTransitionUtilImpl.class);
        workflowTransitionUtil.setAction(this.action);
        workflowTransitionUtil.setIssue(this.getIssueObject());
        if (workflowTransitionUtil.hasScreen()) {
            UrlBuilder builder = new UrlBuilder("CommentAssignIssue!default.jspa");
            Map existingParams = ActionContext.getParameters();
            for (String paramName : existingParams.keySet()) {
                if (!StringUtils.isNotBlank((String)paramName) || "returnUrl".equals(paramName)) continue;
                String[] paramValues = (String[])existingParams.get(paramName);
                for (int i = 0; i < paramValues.length; ++i) {
                    String paramValue = paramValues[i];
                    builder.addParameter(paramName, paramValue);
                }
            }
            return this.forceRedirect(builder.asUrlString());
        }
        return "success";
    }

    private ActionDescriptor getActionDescriptor() {
        String username = this.getLoggedInUser() != null ? this.getLoggedInUser().getName() : null;
        Workflow wf = this.workflowManager.makeWorkflow(username);
        long workflowId = this.getIssue().getLong("workflowId");
        WorkflowDescriptor wd = wf.getWorkflowDescriptor(wf.getWorkflowName(workflowId));
        return wd.getAction(this.action);
    }

    @Override
    public String getWorkflowTransitionDisplayName() {
        return this.getWorkflowTransitionDisplayName(this.getActionDescriptor());
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }
}

