/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.query.Query;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.ImmutableList;
import com.opensymphony.module.propertyset.PropertySet;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import webwork.action.ServletActionContext;

public class ViewUserHover
extends JiraWebActionSupport {
    private static final ImmutableList<Integer> WEEKEND = ImmutableList.of((Object)6, (Object)7);
    private String username;
    private User user;
    private Long avatarId;
    private final UserUtil userUtil;
    private final EmailFormatter emailFormatter;
    private final SearchService searchService;
    private final PermissionManager permissionManager;
    private final SimpleLinkManager simpleLinkManager;
    private final AvatarManager avatarManager;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final TimeZoneService timeZoneService;
    private final LazyReference<SimpleDateFormat> hourOfDayFormatter = new HourOfDayFormatterRef();
    private final UserPropertyManager userPropertyManager;

    public ViewUserHover(UserUtil userUtil, EmailFormatter emailFormatter, SearchService searchService, PermissionManager permissionManager, SimpleLinkManager simpleLinkManager, AvatarManager avatarManager, DateTimeFormatterFactory dateTimeFormatterFactory, TimeZoneService timeZoneService, UserPropertyManager userPropertyManager) {
        this.userUtil = userUtil;
        this.emailFormatter = emailFormatter;
        this.searchService = searchService;
        this.permissionManager = permissionManager;
        this.simpleLinkManager = simpleLinkManager;
        this.avatarManager = avatarManager;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.timeZoneService = timeZoneService;
        this.userPropertyManager = userPropertyManager;
    }

    public String doDefault() throws Exception {
        this.user = this.userUtil.getUserObject(this.username);
        if (this.user != null) {
            PropertySet propertySet = this.userPropertyManager.getPropertySet(this.user);
            if (propertySet.exists("user.avatar.id")) {
                this.avatarId = propertySet.getLong("user.avatar.id");
            }
        } else {
            this.avatarId = this.avatarManager.getAnonymousAvatarId();
        }
        return "success";
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Long getAvatarId() {
        return this.avatarId;
    }

    public void setAvatarId(Long avatarId) {
        this.avatarId = avatarId;
    }

    public String getAssigneeQuery() {
        Query query = JqlQueryBuilder.newClauseBuilder().assignee().eq(this.username).and().resolution().isEmpty().buildQuery();
        return this.searchService.getQueryString(this.getLoggedInUser(), query);
    }

    public String getFormattedEmail() {
        if (this.user != null) {
            return this.emailFormatter.formatEmailAsLink(this.user.getEmailAddress(), this.getLoggedInUser());
        }
        return "";
    }

    public String getTime() {
        return this.dateTimeFormatterFactory.formatter().forLoggedInUser().withStyle(DateTimeStyle.TIME).withZone(this.getUserTimeZone()).format(new Date());
    }

    public String getDayOfWeek() {
        SimpleDateFormat df = new SimpleDateFormat("EEEE", this.getLocale());
        df.setTimeZone(this.getUserTimeZone());
        return df.format(new Date());
    }

    public String getHourOfDay() {
        return ((SimpleDateFormat)this.hourOfDayFormatter.get()).format(new Date());
    }

    public String getTimeZoneCity() {
        User user = this.userUtil.getUserObject(this.user.getName());
        TimeZoneInfo userTimeZoneInfo = this.timeZoneService.getUserTimeZoneInfo((JiraServiceContext)new JiraServiceContextImpl(user));
        return userTimeZoneInfo.getCity();
    }

    @Nullable
    public Boolean getIsWeekend() {
        return WEEKEND.contains((Object)new DateTime((Object)new Date(), DateTimeZone.forTimeZone((TimeZone)this.getUserTimeZone())).getDayOfWeek()) ? Boolean.TRUE : null;
    }

    public boolean hasViewUserPermission() {
        try {
            return this.permissionManager.hasPermission(1, this.getLoggedInUser()) && this.permissionManager.hasProjects(10, this.getLoggedInUser());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SimpleLink getFirstHoverLink() {
        List<SimpleLink> simpleLinkList = this.getHoverLinks();
        if (!simpleLinkList.isEmpty()) {
            return simpleLinkList.get(0);
        }
        return null;
    }

    public List<SimpleLink> getRemainingLinks() {
        List<SimpleLink> simpleLinkList = this.getHoverLinks();
        if (!simpleLinkList.isEmpty()) {
            return simpleLinkList.subList(1, simpleLinkList.size());
        }
        return Collections.emptyList();
    }

    public List<SimpleLink> getHoverLinks() {
        User remoteUser = this.getLoggedInUser();
        HttpServletRequest servletRequest = ServletActionContext.getRequest();
        Map params = MapBuilder.newBuilder().add((Object)"profileUser", (Object)this.getUsername()).add((Object)"jqlquery", (Object)this.getAssigneeQuery()).toMap();
        JiraHelper helper = new JiraHelper(servletRequest, null, params);
        return this.simpleLinkManager.getLinksForSection("system.user.hover.links", remoteUser, helper);
    }

    public boolean isCurrentUserNoAvatar() {
        PropertySet propertySet;
        return this.getLoggedInUser() != null && this.user != null && this.getLoggedInUser().equals(this.user) && !(propertySet = this.userPropertyManager.getPropertySet(this.user)).exists("user.avatar.id");
    }

    protected TimeZone getUserTimeZone() {
        User user = this.userUtil.getUserObject(this.user.getName());
        TimeZoneInfo userTimeZoneInfo = this.timeZoneService.getUserTimeZoneInfo((JiraServiceContext)new JiraServiceContextImpl(user));
        return userTimeZoneInfo.toTimeZone();
    }

    private class HourOfDayFormatterRef
    extends LazyReference<SimpleDateFormat> {
        private HourOfDayFormatterRef() {
        }

        protected SimpleDateFormat create() throws Exception {
            TimeZoneInfo userTimeZone = ViewUserHover.this.timeZoneService.getUserTimeZoneInfo((JiraServiceContext)new JiraServiceContextImpl(ViewUserHover.this.getUser()));
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH");
            dateFormat.setTimeZone(userTimeZone.toTimeZone());
            return dateFormat;
        }
    }
}

