/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.issue.fields.option.TextOption;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.timezone.RegionInfo;
import com.atlassian.jira.timezone.RegionInfoImpl;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneInfoImpl;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.session.SessionPagerFilterManager;
import com.atlassian.jira.web.session.SessionSearchObjectManagerFactory;
import com.atlassian.jira.web.util.HelpUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import webwork.action.ActionContext;

public class UpdateUserPreferences
extends JiraWebActionSupport {
    public static final int MAX_ISSUES_PER_PAGE_SETTING = 1000;
    private static final String DEFAULT_LOCALE = "-1";
    private final UserPreferencesManager userPreferencesManager;
    private final LocaleManager localeManager;
    private final SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory;
    private final TimeZoneService timeZoneManager;
    private String username;
    private long userIssuesPerPage;
    private String userNotificationsMimeType;
    private String userLocale;
    private boolean notifyOwnChanges;
    private boolean shareDefault;
    private boolean keyboardShortcutsEnabled;
    private String timeZoneId;

    public UpdateUserPreferences(UserPreferencesManager userPreferencesManager, LocaleManager localeManager, SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory, TimeZoneService timeZoneManager) {
        this.userPreferencesManager = userPreferencesManager;
        this.localeManager = localeManager;
        this.sessionSearchObjectManagerFactory = sessionSearchObjectManagerFactory;
        this.timeZoneManager = timeZoneManager;
    }

    public String doDefault() {
        User current = this.getLoggedInUser();
        if (current == null || !current.getName().equals(this.username)) {
            return "error";
        }
        this.userPreferencesManager.clearCache(this.getLoggedInUser().getName());
        this.setUserIssuesPerPage(this.getUserPreferences().getLong("user.issues.per.page"));
        this.setUserNotificationsMimeType(this.getUserPreferences().getString("user.notifications.mimetype"));
        this.setNotifyOwnChanges(this.getUserPreferences().getBoolean("user.notify.own.changes"));
        this.setShareDefault(this.getUserPreferences().getBoolean("user.default.share.private"));
        this.setUserLocale(this.getUserPreferences().getString("jira.user.locale"));
        this.setKeyboardShortcutsEnabled(!this.getUserPreferences().getBoolean("user.keyboard.shortcuts.disabled"));
        return "input";
    }

    public boolean getShowPluginHints() {
        return this.getApplicationProperties().getOption("show.plugin.marketing.hints");
    }

    public String getTacUrl() {
        return HelpUtil.getInstance().getHelpPath("plugin.hint.tac").getUrl();
    }

    public long getUserIssuesPerPage() {
        return this.userIssuesPerPage;
    }

    public void setUserIssuesPerPage(long aLong) {
        this.userIssuesPerPage = aLong;
    }

    public String getUserNotificationsMimeType() {
        return this.userNotificationsMimeType;
    }

    public void setUserNotificationsMimeType(String userNotificationsMimeType) {
        this.userNotificationsMimeType = userNotificationsMimeType;
    }

    public void setShareDefault(boolean isPublic) {
        this.shareDefault = isPublic;
    }

    public boolean isShareDefault() {
        return this.shareDefault;
    }

    public Collection<TextOption> getOwnChangesList() {
        String notify = this.getText("preferences.notification.on.short");
        String doNotNotify = this.getText("preferences.notification.off.short");
        return CollectionBuilder.list((Object[])new TextOption[]{new TextOption("true", notify), new TextOption("false", doNotNotify)});
    }

    public Collection<TextOption> getShareList() {
        String publicText = this.getText("preferences.default.share.shared.short");
        String privateText = this.getText("preferences.default.share.unshared.short");
        return CollectionBuilder.list((Object[])new TextOption[]{new TextOption("false", publicText), new TextOption("true", privateText)});
    }

    public String getShareValue() {
        return String.valueOf(this.getUserPreferences().getBoolean("user.default.share.private"));
    }

    public Collection<TextOption> getKeyboardShortcutList() {
        String enabledText = this.getText("preferences.keyboard.shortcuts.enabled");
        String disabledText = this.getText("preferences.keyboard.shortcuts.disabled");
        return CollectionBuilder.list((Object[])new TextOption[]{new TextOption("true", enabledText), new TextOption("false", disabledText)});
    }

    public String getKeyboardShortcutValue() {
        return String.valueOf(!this.getUserPreferences().getBoolean("user.keyboard.shortcuts.disabled"));
    }

    public String getUserLocale() {
        return this.userLocale;
    }

    public void setUserLocale(String userLocale) {
        this.userLocale = userLocale;
    }

    public void setDefaultUserTimeZone(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public List<RegionInfo> getTimeZoneRegions() {
        List regions = this.timeZoneManager.getTimeZoneRegions(this.getJiraServiceContext());
        regions.add(0, new RegionInfoImpl("JIRA", this.getText("timezone.region.jira")));
        return regions;
    }

    public List<TimeZoneInfo> getTimeZoneInfos() {
        List timeZoneInfos = this.timeZoneManager.getTimeZoneInfos(this.getJiraServiceContext());
        TimeZoneInfo jiraDefaultTimeZone = this.timeZoneManager.getDefaultTimeZoneInfo(this.getJiraServiceContext());
        TimeZoneInfoImpl timeZoneInfo = new TimeZoneInfoImpl("JIRA", jiraDefaultTimeZone.getDisplayName(), jiraDefaultTimeZone.toTimeZone(), this.getJiraServiceContext().getI18nBean(), "JIRA");
        timeZoneInfos.add(timeZoneInfo);
        return timeZoneInfos;
    }

    public String getConfiguredTimeZoneRegion() {
        if (this.timeZoneManager.usesJiraTimeZone(this.getJiraServiceContext())) {
            return "JIRA";
        }
        return this.timeZoneManager.getUserTimeZoneInfo(this.getJiraServiceContext()).getRegionKey();
    }

    public String getConfiguredTimeZoneId() {
        if (this.timeZoneManager.usesJiraTimeZone(this.getJiraServiceContext())) {
            return "JIRA";
        }
        return this.timeZoneManager.getUserTimeZoneInfo(this.getJiraServiceContext()).getTimeZoneId();
    }

    public Map getMimeTypes() {
        return EasyMap.build((Object)"html", (Object)"HTML", (Object)"text", (Object)"Text");
    }

    public boolean getNotifyOwnChanges() {
        return this.notifyOwnChanges;
    }

    public void setNotifyOwnChanges(boolean notifyOwnChanges) {
        this.notifyOwnChanges = notifyOwnChanges;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Map<String, String> getInstalledLocales() {
        return this.localeManager.getInstalledLocalesWithDefault(this.getApplicationProperties().getDefaultLocale(), (I18nHelper)this);
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        User current = this.getLoggedInUser();
        if (current == null || !current.getName().equals(this.username)) {
            return "error";
        }
        this.getUserPreferences().setLong("user.issues.per.page", this.getUserIssuesPerPage());
        this.getUserPreferences().setString("user.notifications.mimetype", this.getUserNotificationsMimeType());
        this.getUserPreferences().setBoolean("user.default.share.private", this.isShareDefault());
        this.getUserPreferences().setBoolean("user.notify.own.changes", this.getNotifyOwnChanges());
        this.getUserPreferences().setBoolean("user.keyboard.shortcuts.disabled", !this.isKeyboardShortcutsEnabled());
        if (DEFAULT_LOCALE.equals(this.getUserLocale())) {
            String locale = this.getUserPreferences().getString("jira.user.locale");
            if (locale != null) {
                this.getUserPreferences().remove("jira.user.locale");
            }
        } else {
            this.getUserPreferences().setString("jira.user.locale", this.getUserLocale());
        }
        if ("JIRA".equals(this.timeZoneId)) {
            this.timeZoneManager.clearUserDefaultTimeZone(this.getJiraServiceContext());
        } else {
            this.timeZoneManager.setUserDefaultTimeZone(this.timeZoneId, this.getJiraServiceContext());
        }
        Map session = ActionContext.getSession();
        session.remove("jira.issue.generic.pager");
        this.getSessionPagerFilterManager().setCurrentObject(null);
        this.userPreferencesManager.clearCache(this.getLoggedInUser().getName());
        return this.returnComplete("ViewProfile.jspa");
    }

    private SessionPagerFilterManager getSessionPagerFilterManager() {
        return this.sessionSearchObjectManagerFactory.createPagerFilterManager();
    }

    protected void doValidation() {
        if (this.getUserIssuesPerPage() <= 0L || this.getUserIssuesPerPage() > 1000L) {
            this.addError("userIssuesPerPage", this.getText("preferences.issues.per.page.error"));
        }
        super.doValidation();
    }

    public boolean isKeyboardShortcutsEnabled() {
        return this.keyboardShortcutsEnabled;
    }

    public void setKeyboardShortcutsEnabled(boolean keyboardShortcutsEnabled) {
        this.keyboardShortcutsEnabled = keyboardShortcutsEnabled;
    }
}

