/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.DevModeSecretSauce;
import com.atlassian.jira.web.action.setup.SetupOldUserHelper;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class Setup2
extends AbstractSetupAction {
    String username;
    String fullname;
    String email;
    String password;
    String confirm;
    private String EXISTING_ADMINS = "existingadmins";
    private final UserService userService;
    private UserService.CreateUserValidationResult result;

    public Setup2(UserService userService, FileFactory fileFactory) {
        super(fileFactory);
        this.userService = userService;
    }

    public String doDefault() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        if (SetupOldUserHelper.getExistingAdmins() != null) {
            return this.EXISTING_ADMINS;
        }
        this.setupDevModeUserNames();
        return super.doDefault();
    }

    protected void doValidation() {
        if (this.setupAlready()) {
            return;
        }
        this.result = this.userService.validateCreateUserForSignupOrSetup(this.getLoggedInUser(), this.getUsername(), this.getPassword(), this.getConfirm(), this.getEmail(), this.getFullname());
        if (!this.result.isValid()) {
            this.addErrorCollection(this.result.getErrorCollection());
        }
    }

    protected String doExecute() {
        if (this.setupAlready()) {
            return "setupalready";
        }
        GenericValue administrator = null;
        try {
            if (SetupOldUserHelper.getExistingAdmins() != null) {
                return this.EXISTING_ADMINS;
            }
            administrator = SetupOldUserHelper.addUser(this.result);
            GenericValue groupAdmins = this.getOrCreateGroup("jira-administrators");
            GenericValue groupDevelopers = this.getOrCreateGroup("jira-developers");
            GenericValue groupUsers = this.getOrCreateGroup("jira-users");
            if (administrator != null && groupAdmins != null && groupDevelopers != null && groupUsers != null) {
                SetupOldUserHelper.addToGroup("jira-administrators", this.result.getUsername());
                SetupOldUserHelper.addToGroup("jira-developers", this.result.getUsername());
                SetupOldUserHelper.addToGroup("jira-users", this.result.getUsername());
                ManagerFactory.getGlobalPermissionManager().addPermission(0, "jira-administrators");
            }
        }
        catch (CreateException e) {
            throw new RuntimeException(e);
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e);
        }
        return this.getResult();
    }

    private void setupDevModeUserNames() {
        DevModeSecretSauce setupHelper = new DevModeSecretSauce();
        this.username = setupHelper.getSecretSauceProperty("username");
        this.fullname = setupHelper.getSecretSauceProperty("fullname");
        this.email = setupHelper.getSecretSauceProperty("email");
        this.password = setupHelper.getSecretSauceProperty("password");
        this.confirm = setupHelper.getSecretSauceProperty("password");
    }

    private GenericValue getOrCreateGroup(String groupName) {
        try {
            return SetupOldUserHelper.addGroup(groupName);
        }
        catch (GenericEntityException e) {
            this.addErrorMessage(this.getText("signup.error.group.database.immutable", groupName));
            return null;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }
}

