/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.license.JiraLicenseUpdaterService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.service.services.export.ExportService;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.util.index.Contexts;
import com.atlassian.jira.util.system.JiraSystemRestarter;
import com.atlassian.jira.web.action.setup.AbstractSetupAction;
import com.atlassian.jira.web.action.setup.DevModeSecretSauce;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.velocity.VelocityHelper;
import com.opensymphony.util.TextUtils;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import webwork.action.ActionContext;

public class Setup
extends AbstractSetupAction {
    private String nextStep;
    private String title;
    private String baseURL;
    private String mode = "public";
    private String licenseString;
    private String attachmentPath;
    private AttachmentPathManager.Mode attachmentMode = AttachmentPathManager.Mode.DEFAULT;
    private IndexPathManager.Mode indexMode = IndexPathManager.Mode.DEFAULT;
    private JiraLicenseService.ValidationResult validationResult;
    private final ExternalLinkUtil externalLinkUtil;
    private DirectoryMode backupMode = DirectoryMode.DEFAULT;
    private String indexPath;
    private final IssueIndexManager indexManager;
    private final ServiceManager serviceManager;
    private final IndexPathManager indexPathManager;
    private final AttachmentPathManager attachmentPathManager;
    private final JiraHome jiraHome;
    private final JiraLicenseUpdaterService licenseService;
    private final JiraSystemRestarter jiraSystemRestarter;
    private final BuildUtilsInfo buildUtilsInfo;

    public Setup(IssueIndexManager indexManager, ServiceManager serviceManager, IndexPathManager indexPathManager, AttachmentPathManager attachmentPathManager, JiraHome jiraHome, JiraLicenseUpdaterService licenseService, BuildUtilsInfo buildUtilsInfo, JiraSystemRestarter jiraSystemRestarter, FileFactory fileFactory, ExternalLinkUtil externalLinkUtil) {
        super(fileFactory);
        this.indexManager = indexManager;
        this.serviceManager = serviceManager;
        this.indexPathManager = indexPathManager;
        this.attachmentPathManager = attachmentPathManager;
        this.jiraHome = jiraHome;
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.licenseService = (JiraLicenseUpdaterService)Assertions.notNull((String)"licenseService", (Object)licenseService);
        this.jiraSystemRestarter = (JiraSystemRestarter)Assertions.notNull((String)"jiraSystemRestarter", (Object)jiraSystemRestarter);
        this.externalLinkUtil = (ExternalLinkUtil)Assertions.notNull((String)"externalLinkUtil", (Object)externalLinkUtil);
    }

    public String doDefault() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        ApplicationProperties applicationProperties = this.getApplicationProperties();
        this.title = applicationProperties.getString("jira.title");
        if (this.title == null) {
            this.title = "Your Company JIRA";
            applicationProperties.setString("jira.title", this.title);
        }
        if (applicationProperties.getString("jira.baseurl") != null) {
            this.baseURL = applicationProperties.getString("jira.baseurl");
        }
        if (applicationProperties.getString("jira.mode") != null) {
            this.mode = applicationProperties.getString("jira.mode");
        }
        if (this.attachmentPathManager.getAttachmentPath() != null) {
            this.attachmentPath = this.attachmentPathManager.getAttachmentPath();
        }
        if (this.indexPathManager.getIndexRootPath() != null) {
            this.indexPath = this.indexPathManager.getIndexRootPath();
        }
        this.setupDefaultLicenceString();
        return this.forceRedirectToInput();
    }

    private void setupDefaultLicenceString() {
        LicenseDetails details = this.licenseService.getLicense();
        this.licenseString = details.isLicenseSet() ? details.getLicenseString() : new DevModeSecretSauce().getPrefilledLicence();
    }

    protected void doValidation() {
        if (this.nextStep == null || this.setupAlready()) {
            return;
        }
        if (!TextUtils.stringSet((String)this.title)) {
            this.addError("title", this.getText("setup.error.specifytitle"));
        }
        if (!TextUtils.verifyUrl((String)this.baseURL)) {
            this.addError("baseURL", this.getText("setup.error.baseURL"));
        }
        if (!this.getAllowedModes().keySet().contains(this.mode)) {
            this.addError("mode", this.getText("setup.error.mode"));
        }
        this.validationResult = this.licenseService.validate((I18nHelper)this, this.licenseString);
        ErrorCollection errorCollection = this.validationResult.getErrorCollection();
        if (errorCollection.hasAnyErrors()) {
            this.addErrorCollection(errorCollection);
        }
        super.doValidation();
    }

    public String doInput() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        this.licenseString = new DevModeSecretSauce().getPrefilledLicence();
        return "input";
    }

    private String forceRedirectToInput() {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            if (this.title != null) {
                params.put("title", VelocityHelper.encode((String)this.title, (String)ManagerFactory.getApplicationProperties().getEncoding()));
            }
            if (this.baseURL != null) {
                params.put("baseURL", VelocityHelper.encode((String)this.baseURL, (String)ManagerFactory.getApplicationProperties().getEncoding()));
            }
            if (this.mode != null) {
                params.put("mode", VelocityHelper.encode((String)this.mode, (String)ManagerFactory.getApplicationProperties().getEncoding()));
            }
            if (this.licenseString != null) {
                params.put("license", VelocityHelper.encode((String)this.licenseString, (String)ManagerFactory.getApplicationProperties().getEncoding()));
            }
            if (this.attachmentPath != null) {
                params.put("attachmentPath", VelocityHelper.encode((String)this.attachmentPath, (String)ManagerFactory.getApplicationProperties().getEncoding()));
            }
            if (this.indexPath != null) {
                params.put("indexPath", VelocityHelper.encode((String)this.indexPath, (String)ManagerFactory.getApplicationProperties().getEncoding()));
            }
            if (this.mode != null) {
                params.put("mode", VelocityHelper.encode((String)this.mode, (String)ManagerFactory.getApplicationProperties().getEncoding()));
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        StringBuffer redirectStr = new StringBuffer("Setup!input.jspa");
        int i = 0;
        Iterator iterator = params.keySet().iterator();
        while (iterator.hasNext()) {
            if (i == 0) {
                redirectStr.append("?");
            } else {
                redirectStr.append("&");
            }
            String paramName = (String)iterator.next();
            redirectStr.append(paramName);
            redirectStr.append("=");
            redirectStr.append((String)params.get(paramName));
            ++i;
        }
        return this.forceRedirect(redirectStr.toString());
    }

    public String doFetchLicense() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        Map session = ActionContext.getSession();
        session.put("jira.setup.title", this.title);
        session.put("jira.setup.baseurl", this.baseURL);
        session.put("jira.setup.mode", this.mode);
        if (this.attachmentMode == AttachmentPathManager.Mode.DISABLED) {
            session.put("jira.setup.attachmentmode", false);
        } else {
            session.put("jira.setup.attachmentmode", true);
        }
        if (this.backupMode == DirectoryMode.DISABLED) {
            session.put("jira.setup.backupmode", false);
        } else {
            session.put("jira.setup.backupmode", true);
        }
        return "input";
    }

    public String doReturnFromMAC() throws Exception {
        Map session = ActionContext.getSession();
        this.title = this.getStringFromSession(session, "jira.setup.title", "");
        this.baseURL = this.getStringFromSession(session, "jira.setup.baseurl", this.getBaseURL());
        this.mode = this.getStringFromSession(session, "jira.setup.mode", "public");
        this.attachmentMode = this.getBooleanFromSession(session, "jira.setup.attachmentmode") ? AttachmentPathManager.Mode.DEFAULT : AttachmentPathManager.Mode.DISABLED;
        this.backupMode = this.getBooleanFromSession(session, "jira.setup.backupmode") ? DirectoryMode.DEFAULT : DirectoryMode.DISABLED;
        return "input";
    }

    private String getStringFromSession(Map session, String sessionKey, String defaultValue) {
        if (session.get(sessionKey) == null) {
            return defaultValue;
        }
        return session.get(sessionKey).toString();
    }

    private boolean getBooleanFromSession(Map session, String sessionKey) {
        if (session.get(sessionKey) == null) {
            return true;
        }
        return Boolean.valueOf(session.get(sessionKey).toString());
    }

    protected String doExecute() throws Exception {
        if (this.setupAlready()) {
            return "setupalready";
        }
        if (this.nextStep == null) {
            return this.forceRedirectToInput();
        }
        this.getApplicationProperties().setString("jira.title", this.title);
        this.getApplicationProperties().setString("jira.baseurl", this.baseURL);
        this.getApplicationProperties().setString("jira.mode", this.mode);
        if (this.indexManager.isIndexingEnabled()) {
            try {
                this.indexManager.deactivate();
                this.log.info((Object)"The Index location has already been set but we need to deactivate it before we can reactivate it.\nThis is nothing to worry about it just means that the first stage of the setup has been run more than once.");
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        this.indexPathManager.setUseDefaultDirectory();
        try {
            this.indexManager.activate(Contexts.percentageLogger((Sized)this.indexManager, (Logger)this.log));
        }
        catch (Exception e) {
            this.log.error((Object)("Error activating indexing with path '" + this.indexPath + "': " + e), (Throwable)e);
            this.addError("indexPath", this.getText("setup.error.indexpath.activate_error", e.getMessage()));
        }
        if (this.attachmentMode == AttachmentPathManager.Mode.DISABLED) {
            this.getApplicationProperties().setOption("jira.option.allowattachments", false);
        } else {
            this.attachmentPathManager.setUseDefaultDirectory();
            this.getApplicationProperties().setOption("jira.option.allowattachments", true);
        }
        if (this.backupMode != DirectoryMode.DISABLED) {
            new BackupServiceHelper().createOrUpdateBackupService(new I18nBean(), this.getDefaultBackupPath());
        }
        this.licenseService.setLicense(this.validationResult);
        this.jiraSystemRestarter.ariseSirJIRA();
        return this.getResult();
    }

    public void setNextStep(String nextStep) {
        this.nextStep = nextStep;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getBaseURL() {
        if (this.baseURL == null) {
            this.baseURL = JiraUrl.constructBaseUrl((HttpServletRequest)this.request);
        }
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getLicense() {
        return this.licenseString;
    }

    public void setLicense(String license) {
        this.licenseString = license;
    }

    public Map<String, String> getAllowedModes() {
        HashMap<String, String> allowedModes = new HashMap<String, String>();
        allowedModes.put("public", "Public");
        allowedModes.put("private", "Private");
        return allowedModes;
    }

    public String getHomePath() {
        return this.jiraHome.getHomePath();
    }

    public String getAttachmentPath() {
        return this.attachmentPath;
    }

    public String getAttachmentPathOption() {
        return this.attachmentMode.toString();
    }

    public void setAttachmentPathOption(String attachmentPathOption) {
        this.attachmentMode = AttachmentPathManager.Mode.valueOf((String)attachmentPathOption);
    }

    public String getIndexPathOption() {
        return this.indexMode.toString();
    }

    public void setIndexPathOption(String indexPathOption) {
        this.indexMode = IndexPathManager.Mode.valueOf((String)indexPathOption);
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    public String getDefaultBackupPath() {
        return this.jiraHome.getExportDirectory().getPath();
    }

    public String getBackupPathOption() {
        return this.backupMode.toString();
    }

    public void setBackupPathOption(String backupPathOption) {
        this.backupMode = DirectoryMode.valueOf(backupPathOption);
    }

    public String getRequestLicenseURL() {
        StringBuilder url = new StringBuilder();
        url.append(this.getBaseURL());
        url.append("/secure/Setup!returnFromMAC.jspa");
        return this.externalLinkUtil.getProperty("external.link.jira.license.view", Arrays.asList(this.buildUtilsInfo.getVersion(), this.buildUtilsInfo.getCurrentBuildNumber(), "enterprise", this.getServerId(), url.toString()));
    }

    public BuildUtilsInfo getBuildUtilsInfo() {
        return this.buildUtilsInfo;
    }

    public int modulo(int index, int modulus) {
        return index % modulus;
    }

    private final class BackupServiceHelper {
        private static final String SERVICE_NAME_KEY = "admin.setup.services.backup.service";
        private final long DELAY = DateUtils.HOUR_MILLIS * 12L;

        private BackupServiceHelper() {
        }

        public void createOrUpdateBackupService(I18nHelper i18n, String backupPath) {
            try {
                HashMap<String, String[]> params = new HashMap<String, String[]>();
                params.put("USE_DEFAULT_DIRECTORY", new String[]{"true"});
                String serviceName = this.geti18nTextWithDefault(i18n, SERVICE_NAME_KEY, "Backup Service");
                if (Setup.this.serviceManager.getServiceWithName(serviceName) == null) {
                    Setup.this.serviceManager.addService(serviceName, ExportService.class.getName(), this.DELAY, params);
                } else {
                    Setup.this.serviceManager.editServiceByName(serviceName, this.DELAY, params);
                }
                Setup.this.getApplicationProperties().setString("jira.path.backup", backupPath);
            }
            catch (Exception e) {
                Setup.this.addErrorMessage(Setup.this.getText("admin.errors.setup.error.adding.service", e.toString()));
            }
        }

        String geti18nTextWithDefault(I18nHelper i18n, String key, String defaultString) {
            String result = i18n.getText(key);
            if (key.equals(result)) {
                return defaultString;
            }
            return result;
        }
    }

    private static enum DirectoryMode {
        DEFAULT,
        DISABLED;

    }
}

