/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.bulkedit;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.jira.web.bean.BulkEditBeanSessionHelper;
import com.atlassian.jira.web.component.IssueTableLayoutBean;
import com.atlassian.query.Query;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Collection;
import java.util.List;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class AbstractBulkOperationAction
extends IssueActionSupport {
    private final SearchService searchService;

    public AbstractBulkOperationAction(SearchService searchService) {
        this.searchService = searchService;
    }

    public BulkEditBean getBulkEditBean() {
        return this.getRootBulkEditBean();
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="TODO this needs to be fixed")
    public List getColumns() throws Exception {
        SearchRequest searchRequest = this.getSearchRequest();
        ColumnLayout columnLayout = searchRequest != null && searchRequest.isLoaded() && searchRequest.useColumns() ? ManagerFactory.getFieldManager().getColumnLayoutManager().getColumnLayout(this.getLoggedInUser(), searchRequest) : ManagerFactory.getFieldManager().getColumnLayoutManager().getColumnLayout(this.getLoggedInUser());
        Query query = searchRequest.getQuery();
        QueryContext queryContext = this.searchService.getQueryContext(this.getLoggedInUser(), query);
        return columnLayout.getVisibleColumnLayoutItems(this.getLoggedInUser(), queryContext);
    }

    public IssueTableLayoutBean getIssueTableLayoutBean() throws Exception {
        IssueTableLayoutBean layoutBean = new IssueTableLayoutBean(this.getColumns());
        layoutBean.setSortingEnabled(false);
        return layoutBean;
    }

    protected void clearBulkEditBean() {
        BulkEditBeanSessionHelper.removeFromSession();
    }

    protected String finishWizard() throws Exception {
        this.clearBulkEditBean();
        return this.getRedirect("/secure/IssueNavigator.jspa");
    }

    public BulkEditBean getRootBulkEditBean() {
        BulkEditBean bean = BulkEditBeanSessionHelper.getFromSession();
        if (bean == null) {
            this.log.warn((Object)"Bulk edit bean unexpectedly null. Perhaps session was lost (e.g. when URL used is different to base URL in General Configuration)?");
        }
        return bean;
    }

    public boolean isCanDisableMailNotifications() {
        if (this.isHasPermission(0)) {
            return true;
        }
        Collection projects = this.getBulkEditBean().getProjects();
        for (GenericValue projectGV : projects) {
            if (this.isHasProjectPermission(23, projectGV)) continue;
            return false;
        }
        return true;
    }

    public boolean isSendBulkNotification() {
        return this.getBulkEditBean().isSendBulkNotification();
    }

    public void setSendBulkNotification(boolean sendBulkNotification) {
        if (this.getBulkEditBean() != null) {
            this.getBulkEditBean().setSendBulkNotification(sendBulkNotification);
        }
    }

    protected String redirectToStart(String i18nMessage) {
        ActionContext.getSession().put("jira.session.timeout.message", this.getText(i18nMessage));
        return this.getRedirect("SessionTimeoutMessage.jspa");
    }
}

