/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.movesubtask.MoveSubTaskOperationManager;
import com.atlassian.jira.movesubtask.operation.MoveSubTaskOperation;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.issue.MoveIssue;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.util.TextUtils;
import java.util.Collection;

public class MoveSubTaskChooseOperation
extends MoveIssue {
    private Collection moveSubTaskOperations;
    private String operation;
    final MoveSubTaskOperationManager moveSubTaskOperationManager;

    public MoveSubTaskChooseOperation(IssueLinkManager issueLinkManager, SubTaskManager subTaskManager, ConstantsManager constantsManager, WorkflowManager workflowManager, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, IssueFactory issueFactory, FieldScreenRendererFactory fieldScreenRendererFactory, MoveSubTaskOperationManager moveSubTaskOperationManager, CommentService commentService, UserUtil userUtil) {
        super(issueLinkManager, subTaskManager, constantsManager, workflowManager, fieldManager, fieldLayoutManager, issueFactory, fieldScreenRendererFactory, commentService, userUtil);
        this.moveSubTaskOperationManager = moveSubTaskOperationManager;
        this.moveSubTaskOperations = moveSubTaskOperationManager.getMoveSubTaskOperations();
    }

    @Override
    public String doDefault() throws Exception {
        String result = super.doDefault();
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        this.getMoveIssueBean().setCurrentStep(0);
        return result;
    }

    @Override
    protected void doValidation() {
        if (this.getMoveIssueBean() != null) {
            if (this.getIssue() == null) {
                this.addErrorMessage("move.subtask.no.issue.selected");
            }
            if (!TextUtils.stringSet((String)this.getOperation())) {
                this.addErrorMessage(this.getText("move.chooseoperation.error.choose.operation"));
            } else if (!this.moveSubTaskOperationManager.isValidOperation(this.getOperation())) {
                this.addErrorMessage(this.getText("move.chosseoperation.error.invalid.operation"));
            }
        }
    }

    @Override
    protected String doExecute() throws Exception {
        if (this.getMoveIssueBean() == null) {
            return this.redirectToSessionTimeoutPage();
        }
        String operationName = this.moveSubTaskOperationManager.getOperation(this.getOperation()).getOperationName();
        this.getMoveIssueBean().setCurrentStep(1);
        this.getMoveIssueBean().addAvailablePreviousStep(0);
        return this.forceRedirect(operationName + "!default.jspa?id=" + this.getIssue().get("id"));
    }

    public Collection getMoveSubTaskOperations() {
        return this.moveSubTaskOperations;
    }

    public boolean isCanPerform(MoveSubTaskOperation moveSubTaskOperation) throws Exception {
        return moveSubTaskOperation.canPerform(this.getMoveIssueBean(), this.getLoggedInUser());
    }

    public String getCannotPerformMessageKey(MoveSubTaskOperation moveSubTaskOperation) {
        return moveSubTaskOperation.getCannotPerformMessageKey(this.getMoveIssueBean());
    }

    public boolean isHasAvailableOperations() throws Exception {
        for (MoveSubTaskOperation moveSubTaskOperation : this.moveSubTaskOperations) {
            if (!this.isCanPerform(moveSubTaskOperation)) continue;
            return true;
        }
        return false;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public void setCurrentStep(int step) {
        this.getMoveIssueBean().setCurrentStep(step);
    }
}

