/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.pager.NextPreviousPager;
import com.atlassian.jira.issue.pager.PagerManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.trackback.TrackbackManager;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import com.atlassian.trackback.Trackback;
import java.util.ArrayList;
import java.util.Collection;
import org.ofbiz.core.entity.GenericEntityException;

public class ManageTrackbacks
extends AbstractIssueSelectAction {
    private final TrackbackManager trackbackManager;
    private Long trackbackId;
    private boolean confirm;
    private Collection trackbacks;
    Collection affectedVersions;
    Collection components;
    Collection fixVersions;
    PagerManager pagerManager;
    private Issue parentIssueObject = null;

    public ManageTrackbacks(TrackbackManager trackbackManager, PagerManager pagerManager) {
        this.trackbackManager = trackbackManager;
        this.pagerManager = pagerManager;
    }

    public String doDelete() throws Exception {
        if (!this.isCanDeleteTrackbacks()) {
            return "error";
        }
        if (this.confirm) {
            this.trackbackManager.deleteTrackback(this.trackbackId);
            return this.getRedirect("ManageTrackbacks.jspa?id=" + this.getIssue().get("id"));
        }
        return "input";
    }

    protected String doExecute() throws Exception {
        NextPreviousPager pager = this.getNextPreviousPager();
        if (pager != null) {
            MutableIssue issue = this.getIssueObject();
            pager.update(this.getSearchRequest(), this.getLoggedInUser(), issue == null ? null : issue.getKey());
        }
        return super.doExecute();
    }

    @Override
    public boolean isSubTask() {
        MutableIssue issue = this.getIssueObject();
        return issue != null && issue.isSubTask();
    }

    @Override
    public Issue getParentIssueObject() {
        MutableIssue issue;
        if (this.isSubTask() && this.parentIssueObject == null && (issue = this.getIssueObject()) != null && issue.isSubTask() && issue.getParentObject() != null) {
            this.parentIssueObject = issue.getParentObject();
        }
        return this.parentIssueObject;
    }

    public Long getTrackbackId() {
        return this.trackbackId;
    }

    public void setTrackbackId(Long trackbackId) {
        this.trackbackId = trackbackId;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public boolean isCanDeleteTrackbacks() {
        return this.isHasIssuePermission(16, this.getIssue());
    }

    public Collection getTrackbacks() throws GenericEntityException {
        if (this.trackbacks == null) {
            this.trackbacks = this.trackbackManager.getTrackbacksForIssue(this.getIssue());
        }
        return this.trackbacks;
    }

    public Trackback getTrackback(Long id) throws GenericEntityException {
        return this.trackbackManager.getTrackback(id);
    }

    public Collection getComponents() throws Exception {
        if (this.getIssueObject() != null && this.components == null) {
            this.components = this.getIssueObject().getComponents();
        }
        return this.components;
    }

    public Collection getAffectedVersions() throws Exception {
        if (this.getIssueObject() != null && this.affectedVersions == null) {
            this.affectedVersions = new ArrayList();
            for (Version version : this.getIssueObject().getAffectedVersions()) {
                this.affectedVersions.add(version.getGenericValue());
            }
        }
        return this.affectedVersions;
    }

    public Collection getFixVersions() throws Exception {
        if (this.getIssueObject() != null && this.fixVersions == null) {
            this.fixVersions = new ArrayList();
            for (Version version : this.getIssueObject().getFixVersions()) {
                this.fixVersions.add(version.getGenericValue());
            }
        }
        return this.fixVersions;
    }

    public NextPreviousPager getNextPreviousPager() {
        return this.pagerManager.getPager();
    }
}

