/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.issuelink.IssueLinkService;
import com.atlassian.jira.bc.issue.issuelink.RemoteIssueLinkService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.link.IssueLinkDisplayHelper;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.issue.link.RemoteJiraGlobalId;
import com.atlassian.jira.issue.link.RemoteJiraGlobalIdFactory;
import com.atlassian.jira.issue.link.RemoteJiraRestHelper;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.action.issue.AbstractCommentableIssue;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.net.ResponseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class LinkRemoteIssue
extends AbstractCommentableIssue
implements OperationContext {
    private static final String RECIPROCAL_ERROR = "reciprocalerror";
    private static final String REST_VERSION = "2";
    private static final String JIRA_APPLICATION_TYPE = "com.atlassian.jira";
    private Collection<String> linkDescs;
    private Collection<ApplicationLink> jiraAppLinks;
    private String linkDesc;
    private String jiraAppId;
    private String remoteIssue;
    private boolean createReciprocal = false;
    private IssueLinkType issueLinkType;
    private ApplicationLink jiraAppLink;
    private RemoteIssueLinkService.CreateValidationResult validationResult;
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueLinkService issueLinkService;
    private final IssueLinkDisplayHelper issueLinkDisplayHelper;
    private final UserHistoryManager userHistoryManager;
    private final RemoteIssueLinkService remoteIssueLinkService;
    private final ApplicationLinkService applicationLinkService;
    private final RemoteJiraRestHelper restHelper;

    public LinkRemoteIssue(IssueLinkManager issueLinkManager, IssueLinkTypeManager issueLinkTypeManager, SubTaskManager subTaskManager, FieldManager fieldManager, FieldScreenRendererFactory fieldScreenRendererFactory, ProjectRoleManager projectRoleManager, CommentService commentService, UserHistoryManager userHistoryManager, IssueLinkService issueLinkService, UserUtil userUtil, RemoteIssueLinkService remoteIssueLinkService, ApplicationLinkService applicationLinkService, RemoteJiraRestHelper restHelper) {
        super(issueLinkManager, subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil);
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueLinkService = issueLinkService;
        this.userHistoryManager = userHistoryManager;
        this.issueLinkDisplayHelper = new IssueLinkDisplayHelper(userHistoryManager, this.getLoggedInUser());
        this.remoteIssueLinkService = remoteIssueLinkService;
        this.applicationLinkService = applicationLinkService;
        this.restHelper = restHelper;
        ComponentManager.getComponent(WebResourceManager.class).requireResource("jira.webresources:jira-fields");
    }

    @Override
    protected void doValidation() {
        JSONObject jsonIssue;
        if (!this.isHasIssuePermission(21, this.getIssue())) {
            this.addErrorMessage(this.getText("linkissue.error.nopermission"));
        }
        super.doValidation();
        if (StringUtils.isBlank((String)this.jiraAppId)) {
            this.addError("jiraAppId", this.getText("linkremoteissue.error.jira.app.required"));
        } else if (this.getJiraAppLink() == null) {
            this.addError("jiraAppId", this.getText("linkremoteissue.error.jira.app.invalid"));
        }
        if (!this.getLinkDescs().contains(this.linkDesc)) {
            this.addError("linkDesc", this.getText("linkremoteissue.error.link.desc.invalid"));
        } else if (this.getIssueLinkType().isSystemLinkType()) {
            this.addError("linkDesc", this.getText("linkremoteissue.error.systemlink"));
        }
        if (StringUtils.isBlank((String)this.remoteIssue)) {
            this.addError("remoteIssue", this.getText("linkremoteissue.error.remoteissue.required"));
        }
        if (!this.hasAnyErrors() && (jsonIssue = this.queryRemoteIssue(this.getJiraAppLink(), this.remoteIssue)) != null && !this.hasAnyErrors()) {
            this.validationResult = this.validateCreate(jsonIssue);
        }
    }

    public String doDefault() throws Exception {
        try {
            this.getIssueObject();
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        catch (IssuePermissionException e) {
            return "error";
        }
        return super.doDefault();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        RemoteJiraRestHelper.RestResponse response;
        RemoteIssueLinkService.RemoteIssueLinkResult result = this.remoteIssueLinkService.create(this.getLoggedInUser(), this.validationResult);
        if (!result.isValid()) {
            this.mapErrors(result.getErrorCollection());
            this.addErrorCollection(result.getErrorCollection());
            return "error";
        }
        this.userHistoryManager.addItemToHistory(UserHistoryItem.ISSUELINKTYPE, this.getLoggedInUser(), String.valueOf(this.getIssueLinkType().getId()), this.linkDesc);
        try {
            this.createComment(this.getIssueObject());
        }
        catch (Exception e) {
            this.addErrorMessage(this.getText("admin.errors.issues.an.error.occured", e));
            return "error";
        }
        this.getIssueObject().resetModifiedFields();
        if (this.createReciprocal && !(response = this.restHelper.createRemoteIssueLink(this.getJiraAppLink(), this.remoteIssue, (Issue)this.getIssueObject(), this.getReciprocalLinkDesc(), REST_VERSION)).isSuccessful()) {
            return RECIPROCAL_ERROR;
        }
        return this.getRedirectUrl();
    }

    private String getRedirectUrl() {
        if (this.isInlineDialogMode()) {
            return this.returnCompleteWithInlineRedirect("/browse/" + this.getIssue().getString("key") + "#linkingmodule");
        }
        return this.returnComplete("/browse/" + this.getIssue().getString("key") + "#linkingmodule");
    }

    private JSONObject queryRemoteIssue(ApplicationLink applicationLink, String issueKey) {
        try {
            RemoteJiraRestHelper.RestResponse response = RemoteJiraRestHelper.getIssueResponse(applicationLink, issueKey, REST_VERSION);
            if (response.isSuccessful()) {
                return response.getJsonObject();
            }
            switch (response.getStatusCode()) {
                case 404: {
                    this.addErrorMessage(this.getText("linkremoteissue.error.remoteissue.notfound"));
                    break;
                }
                case 403: {
                    this.addErrorMessage(this.getText("linkremoteissue.error.remoteissue.forbidden"));
                    break;
                }
                case 401: {
                    this.addErrorMessage(this.getText("linkremoteissue.error.remoteissue.unauthorised"));
                    break;
                }
                default: {
                    this.addErrorMessage(this.getText("linkremoteissue.error.invalid.response"));
                    this.log.error((Object)("Invalid response from remote JIRA server: " + response.getStatusCode() + ": " + response.getStatusText()));
                    break;
                }
            }
        }
        catch (CredentialsRequiredException e) {
            this.addErrorMessage(this.getText("linkremoteissue.error.remoteissue.unauthorised"));
        }
        catch (ResponseException e) {
            this.addErrorMessage(this.getText("linkremoteissue.error.invalid.response"));
            this.log.error((Object)("Invalid response from remote JIRA server: " + e.getMessage()));
        }
        return null;
    }

    private RemoteIssueLinkService.CreateValidationResult validateCreate(JSONObject jsonIssue) {
        try {
            Long remoteIssueId = jsonIssue.getLong("id");
            String remoteIssueKey = jsonIssue.getString("key");
            String remoteIssueUrl = RemoteJiraRestHelper.buildIssueUrl(this.getJiraAppLink().getDisplayUrl(), this.remoteIssue);
            String globalId = RemoteJiraGlobalIdFactory.encode(new RemoteJiraGlobalId(this.getJiraAppLink(), remoteIssueId));
            RemoteIssueLink remoteIssueLink = new RemoteIssueLinkBuilder().url(remoteIssueUrl).title(remoteIssueKey).globalId(globalId).issueId(remoteIssueId).relationship(this.linkDesc).applicationName(this.getJiraAppLink().getName()).applicationType(JIRA_APPLICATION_TYPE).build();
            RemoteIssueLinkService.CreateValidationResult validationResult = this.remoteIssueLinkService.validateCreate(this.getLoggedInUser(), remoteIssueLink);
            if (!validationResult.isValid()) {
                this.mapErrors(validationResult.getErrorCollection());
                this.addErrorCollection(validationResult.getErrorCollection());
            }
            return validationResult;
        }
        catch (JSONException e) {
            this.addErrorMessage(this.getText("linkremoteissue.error.invalid.response"));
            this.log.error((Object)("Invalid JSON returned from remote JIRA server: " + e.getMessage()));
            return null;
        }
    }

    private void mapErrors(ErrorCollection errorCollection) {
        for (Map.Entry entry : errorCollection.getErrors().entrySet()) {
            errorCollection.addErrorMessage((String)entry.getValue());
        }
    }

    private String getReciprocalLinkDesc() {
        IssueLinkType linkType = this.getIssueLinkType();
        if (linkType == null) {
            return null;
        }
        if (this.linkDesc.equals(linkType.getOutward())) {
            return linkType.getInward();
        }
        return linkType.getOutward();
    }

    private IssueLinkType getIssueLinkType() {
        if (this.issueLinkType == null) {
            for (IssueLinkType linkType : this.issueLinkTypeManager.getIssueLinkTypes()) {
                if (!this.linkDesc.equals(linkType.getOutward()) && !this.linkDesc.equals(linkType.getInward())) continue;
                this.issueLinkType = linkType;
                break;
            }
        }
        return this.issueLinkType;
    }

    public String getLinkDesc() {
        return this.linkDesc;
    }

    public void setLinkDesc(String linkDesc) {
        this.linkDesc = linkDesc;
    }

    public Collection<String> getLinkDescs() {
        if (this.linkDescs == null) {
            this.linkDescs = this.issueLinkDisplayHelper.getSortedIssueLinkTypes(this.issueLinkService.getIssueLinkTypes());
        }
        return this.linkDescs;
    }

    public String getLastUsedLinkType() {
        return this.issueLinkDisplayHelper.getLastUsedLinkType();
    }

    private ApplicationLink getJiraAppLink() {
        if (this.jiraAppLink == null) {
            for (ApplicationLink appLink : this.getJiraAppLinks()) {
                if (!appLink.getId().get().equals(this.jiraAppId)) continue;
                this.jiraAppLink = appLink;
            }
        }
        return this.jiraAppLink;
    }

    public String getJiraAppId() {
        return this.jiraAppId;
    }

    public void setJiraAppId(String jiraAppLinkId) {
        this.jiraAppId = jiraAppLinkId;
    }

    public Collection<ApplicationLink> getJiraAppLinks() {
        if (this.jiraAppLinks == null) {
            Iterable iterable = this.applicationLinkService.getApplicationLinks(JiraApplicationType.class);
            this.jiraAppLinks = new ArrayList<ApplicationLink>();
            for (ApplicationLink appLink : iterable) {
                this.jiraAppLinks.add(appLink);
            }
        }
        return this.jiraAppLinks;
    }

    public String getRemoteIssue() {
        return this.remoteIssue;
    }

    public void setRemoteIssue(String remoteIssue) {
        this.remoteIssue = remoteIssue;
    }

    public boolean isCreateReciprocal() {
        return this.createReciprocal;
    }

    public void setCreateReciprocal(boolean createReciprocal) {
        this.createReciprocal = createReciprocal;
    }

    public String getRemoteIssueUrl() {
        return RemoteJiraRestHelper.buildIssueUrl(this.getJiraAppLink().getDisplayUrl(), this.remoteIssue);
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>(super.getDisplayParams());
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

