/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.issuelink.IssueLinkService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.link.IssueLinkDisplayHelper;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.issue.AbstractCommentableIssue;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LinkExistingIssue
extends AbstractCommentableIssue
implements OperationContext {
    private String[] linkKey;
    private String linkDesc;
    private Collection<String> linkDescs;
    private IssueLinkType issueLinkType;
    private final List<MutableIssue> issues = new ArrayList<MutableIssue>();
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final IssueLinkService issueLinkService;
    private final IssueLinkDisplayHelper issueLinkDisplayHelper;
    private final UserHistoryManager userHistoryManager;

    public LinkExistingIssue(IssueLinkManager issueLinkManager, IssueLinkTypeManager issueLinkTypeManager, SubTaskManager subTaskManager, FieldManager fieldManager, FieldScreenRendererFactory fieldScreenRendererFactory, ProjectRoleManager projectRoleManager, CommentService commentService, UserHistoryManager userHistoryManager, IssueLinkService issueLinkService, UserUtil userUtil) {
        super(issueLinkManager, subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil);
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.issueLinkService = issueLinkService;
        this.userHistoryManager = userHistoryManager;
        this.issueLinkDisplayHelper = new IssueLinkDisplayHelper(userHistoryManager, this.getLoggedInUser());
        ComponentManager.getComponent(WebResourceManager.class).requireResource("jira.webresources:jira-fields");
    }

    @Override
    protected void doValidation() {
        try {
            if (!this.isHasIssuePermission(21, this.getIssue())) {
                this.addErrorMessage(this.getText("linkissue.error.nopermission"));
            }
            super.doValidation();
            if (this.linkKey != null && this.linkKey.length > 0) {
                for (String key : this.linkKey) {
                    MutableIssue issue = ComponentManager.getComponent(IssueManager.class).getIssueObject(key);
                    if (issue == null) {
                        this.addError("linkKey", this.getText("linkissue.error.notexist", key));
                        continue;
                    }
                    if (key.equals(this.getIssue().getString("key"))) {
                        this.addError("linkKey", this.getText("linkissue.error.selflink"));
                        continue;
                    }
                    this.issues.add(issue);
                }
            } else {
                this.addError("linkKey", this.getText("linkissue.error.keyrequired"));
            }
            if (!this.getLinkDescs().contains(this.linkDesc)) {
                this.addError("linkDesc", this.getText("linkissue.error.invalidlinkdesc"));
            } else if (this.getIssueLinkType().isSystemLinkType()) {
                this.addError("linkDesc", this.getText("linkissue.error.systemlink"));
            }
        }
        catch (IssueNotFoundException e) {
        }
        catch (IssuePermissionException issuePermissionException) {
            // empty catch block
        }
    }

    public String doDefault() throws Exception {
        try {
            this.getIssueObject();
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        catch (IssuePermissionException e) {
            return "error";
        }
        return super.doDefault();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        IssueLinkType linkType = this.getIssueLinkType();
        boolean addLocalComment = true;
        for (MutableIssue issue : this.issues) {
            this.linkIssue(linkType, issue, addLocalComment);
            addLocalComment = false;
        }
        if (this.isInlineDialogMode()) {
            return this.returnCompleteWithInlineRedirect("/browse/" + this.getIssue().getString("key") + "#linkingmodule");
        }
        return this.returnComplete("/browse/" + this.getIssue().getString("key") + "#linkingmodule");
    }

    private void linkIssue(IssueLinkType linkType, MutableIssue destinationIssue, boolean addCommentToLocalIssue) {
        try {
            if (this.linkDesc.equals(linkType.getOutward())) {
                this.getIssueLinkManager().createIssueLink(this.getIssue().getLong("id"), destinationIssue.getId(), linkType.getId(), null, this.getLoggedInUser());
            } else {
                this.getIssueLinkManager().createIssueLink(destinationIssue.getId(), this.getIssue().getLong("id"), linkType.getId(), null, this.getLoggedInUser());
            }
            this.userHistoryManager.addItemToHistory(UserHistoryItem.ISSUELINKTYPE, this.getLoggedInUser(), String.valueOf(linkType.getId()), this.linkDesc);
            if (addCommentToLocalIssue) {
                this.createComment(this.getIssueObject());
            }
            this.createComment(destinationIssue);
            this.getIssueObject().resetModifiedFields();
        }
        catch (Exception e) {
            this.log.error((Object)("Error occurred creating link: " + e), (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.issues.an.error.occured", e));
        }
    }

    private IssueLinkType getIssueLinkType() {
        if (this.issueLinkType == null) {
            for (IssueLinkType linkType : this.issueLinkTypeManager.getIssueLinkTypes()) {
                if (!this.linkDesc.equals(linkType.getOutward()) && !this.linkDesc.equals(linkType.getInward())) continue;
                this.issueLinkType = linkType;
                break;
            }
        }
        return this.issueLinkType;
    }

    public String[] getLinkKey() {
        return this.linkKey;
    }

    public void setLinkKey(String[] linkKey) {
        this.linkKey = linkKey;
    }

    public String getLinkDesc() {
        return this.linkDesc;
    }

    public void setLinkDesc(String linkDesc) {
        this.linkDesc = linkDesc;
    }

    public Collection getLinkDescs() {
        if (this.linkDescs == null) {
            this.linkDescs = this.issueLinkDisplayHelper.getSortedIssueLinkTypes(this.issueLinkService.getIssueLinkTypes());
        }
        return this.linkDescs;
    }

    public String getLastUsedLinkType() {
        return this.issueLinkDisplayHelper.getLastUsedLinkType();
    }

    public List<MutableIssue> getCurrentValue() {
        return this.issues;
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>(super.getDisplayParams());
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

