/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;
import org.ofbiz.core.entity.GenericEntityException;

public class DeleteLink
extends AbstractIssueSelectAction {
    private final IssueLinkManager issueLinkManager;
    private Long destId;
    private Long linkType;
    private Long sourceId;
    private IssueLink issueLink;
    private boolean confirm;

    public DeleteLink(IssueLinkManager issueLinkManager) {
        this.issueLinkManager = issueLinkManager;
    }

    protected void doValidation() {
        try {
            if (this.linkType != null && !this.isHasIssuePermission(21, this.getIssue())) {
                this.addErrorMessage(this.getText("admin.errors.issues.no.permission.to.delete.links"));
            }
            if ((this.destId != null || this.sourceId != null) && this.linkType != null && this.getLink() == null) {
                this.addErrorMessage(this.getText("admin.errors.issues.cannot.find.link"));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Exception: " + e), (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.issues.exception.occured.validating", e));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.confirm) {
            try {
                this.issueLinkManager.removeIssueLink(this.getLink(), this.getLoggedInUser());
            }
            catch (RemoveException e) {
                this.addErrorMessage(this.getText("admin.errors.issues.error.occured.removing.link", (Object)e));
                this.log.error((Object)("An error occurred removing link: " + (Object)((Object)e)), (Throwable)e);
                return "error";
            }
            String targetID = this.issueLinkManager.getLinkCollection((Issue)this.getIssueObject(), this.getLoggedInUser()).getAllIssues().isEmpty() ? "" : "#linkingmodule";
            String redirectUrl = "/browse/" + this.getIssueObject().getKey() + targetID;
            if (this.isInlineDialogMode()) {
                return this.returnCompleteWithInlineRedirect(redirectUrl);
            }
            return this.returnComplete(redirectUrl);
        }
        return "input";
    }

    public String getDirectionName() throws GenericEntityException {
        if (this.destId != null) {
            return this.getLink().getIssueLinkType().getOutward();
        }
        if (this.sourceId != null) {
            return this.getLink().getIssueLinkType().getInward();
        }
        return null;
    }

    public String getTargetIssueKey() {
        MutableIssue issue = this.getIssueManager().getIssueObject(this.destId != null ? this.destId : this.sourceId);
        if (issue != null) {
            return issue.getKey();
        }
        return null;
    }

    public Long getDestId() {
        return this.destId;
    }

    public void setDestId(Long destId) {
        this.destId = destId;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getLinkType() {
        return this.linkType;
    }

    public void setLinkType(Long linkType) {
        this.linkType = linkType;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public boolean isRemoteIssueLink() {
        return false;
    }

    private IssueLink getLink() throws GenericEntityException {
        if (this.issueLink == null) {
            if (this.destId != null) {
                this.issueLink = this.issueLinkManager.getIssueLink(this.getId(), this.destId, this.linkType);
            } else if (this.sourceId != null) {
                this.issueLink = this.issueLinkManager.getIssueLink(this.sourceId, this.getId(), this.linkType);
            }
        }
        return this.issueLink;
    }
}

