/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.issue.AbstractViewIssue;
import com.opensymphony.util.TextUtils;

public class DeleteIssue
extends AbstractViewIssue {
    boolean confirm;
    private Integer numberOfSubTasks;
    private final IssueService issueService;
    private IssueService.DeleteValidationResult issueValidationResult;

    public DeleteIssue(IssueLinkManager issueLinkManager, SubTaskManager subTaskManager, IssueService issueService) {
        super(issueLinkManager, subTaskManager);
        this.issueService = issueService;
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ErrorCollection errors;
        if (this.confirm && (errors = this.issueService.delete(this.getLoggedInUser(), this.issueValidationResult)).hasAnyErrors()) {
            this.addErrorCollection(errors);
        }
        return this.returnComplete(this.getViewUrl());
    }

    private boolean isCurrentDeletedIssue(String returnUrl) {
        String key = this.getIssueObject().getKey();
        return returnUrl.endsWith("browse/" + key) || returnUrl.contains("browse/" + key + "?");
    }

    @Override
    public String getViewUrl() {
        String returnUrl = this.getReturnUrl();
        if (TextUtils.stringSet((String)returnUrl) && !this.isCurrentDeletedIssue(returnUrl)) {
            return returnUrl;
        }
        if (TextUtils.stringSet((String)this.getViewIssueKey())) {
            return "/browse/" + this.getViewIssueKey();
        }
        return "/secure/IssueNavigator.jspa";
    }

    public String getTargetUrl() {
        return this.getViewUrl();
    }

    protected void doValidation() {
        this.issueValidationResult = this.issueService.validateDelete(this.getLoggedInUser(), this.getIssueObject().getId());
        if (!this.issueValidationResult.isValid()) {
            this.addErrorCollection(this.issueValidationResult.getErrorCollection());
        }
    }

    public String doDefault() throws Exception {
        IssueService.IssueResult issueResult = this.issueService.getIssue(this.getLoggedInUser(), this.getId());
        this.addErrorCollection(issueResult.getErrorCollection());
        return "input";
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public int getNumberOfSubTasks() {
        if (this.numberOfSubTasks == null) {
            this.numberOfSubTasks = new Integer(this.getSubTaskManager().getSubTaskIssueLinks(this.getIssue().getLong("id")).size());
        }
        return this.numberOfSubTasks;
    }
}

