/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.subtask.conversion.IssueConversionService;
import com.atlassian.jira.bc.subtask.conversion.IssueToSubTaskConversionService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.action.issue.AbstractConvertIssue;
import com.atlassian.jira.web.bean.ConvertIssueBean;
import com.atlassian.jira.web.bean.ConvertIssueToSubTaskBean;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.util.TextUtils;
import java.util.Collection;

public class ConvertIssueToSubTask
extends AbstractConvertIssue {
    private final IssueToSubTaskConversionService service;
    protected String parentIssueKey;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private static final String FIELDNAME_PARENT_ISSUE_KEY = "parentIssueKey";
    private static final String ISSUE_TO_SUBTASK = "convert.issue.to.subtask";
    private static final String CONVERT_ISSUE = "ConvertIssue";

    public ConvertIssueToSubTask(IssueToSubTaskConversionService service, IssueManager issueManager, ConstantsManager constantsManager, WorkflowManager workflowManager, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, PermissionManager permissionManager, IssueTypeSchemeManager issueTypeSchemeManager, IssueFactory issueFactory) {
        super((IssueConversionService)service, issueManager, fieldLayoutManager, constantsManager, workflowManager, rendererManager, issueFactory, permissionManager);
        this.service = service;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
    }

    @Override
    protected void validateStep1(JiraServiceContextImpl context) {
        super.validateStep1(context);
        this.validateParentIssue((JiraServiceContext)context);
    }

    @Override
    protected MutableIssue getTargetIssueObjectWithSecurityLevel() {
        MutableIssue issue = super.getTargetIssueObjectWithSecurityLevel();
        issue.setParentId(this.issueManager.getIssueObject(((ConvertIssueToSubTaskBean)this.getBean()).getParentIssueKey()).getId());
        return issue;
    }

    private void validateParentIssue(JiraServiceContext context) {
        String key = this.getParentIssueKey();
        if (!TextUtils.stringSet((String)key)) {
            this.addI18nError(context, FIELDNAME_PARENT_ISSUE_KEY, "convert.issue.to.subtask.error.noparentissuekey");
        }
        MutableIssue parentIssue = this.issueManager.getIssueObject(key);
        if (TextUtils.stringSet((String)key) && parentIssue == null) {
            this.addI18nError(context, FIELDNAME_PARENT_ISSUE_KEY, "convert.issue.to.subtask.error.invalidparentissuekey", key);
        }
        if (parentIssue != null) {
            this.service.validateParentIssue(context, this.getIssue(), (Issue)parentIssue, FIELDNAME_PARENT_ISSUE_KEY);
        }
    }

    @Override
    protected ConvertIssueBean getBean() {
        return ConvertIssueToSubTaskBean.getConvertIssueToSubTaskBean(this.request.getSession(), this.getId());
    }

    public void setParentIssueKey(String issueKey) {
        this.parentIssueKey = issueKey;
    }

    @Override
    protected void initExtraFields(ConvertIssueBean bean, JiraServiceContext context) {
        if (this.wasPassed(FIELDNAME_PARENT_ISSUE_KEY)) {
            ((ConvertIssueToSubTaskBean)bean).setParentIssueKey(this.parentIssueKey);
        }
    }

    @Override
    public Collection getAvailableIssueTypes() {
        return this.issueTypeSchemeManager.getSubTaskIssueTypesForProject(this.getIssue().getProjectObject());
    }

    @Override
    public String getActionPrefix() {
        return CONVERT_ISSUE;
    }

    @Override
    public String getPropertiesPrefix() {
        return ISSUE_TO_SUBTASK;
    }
}

