/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.issuelink.RemoteIssueLinkService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.issue.AbstractCommentableIssue;
import java.util.HashMap;
import java.util.Map;

public class AddWebLink
extends AbstractCommentableIssue
implements OperationContext {
    private String url;
    private String title;
    private RemoteIssueLinkService.CreateValidationResult validationResult;
    private final RemoteIssueLinkService remoteIssueLinkService;

    public AddWebLink(IssueLinkManager issueLinkManager, SubTaskManager subTaskManager, FieldManager fieldManager, FieldScreenRendererFactory fieldScreenRendererFactory, ProjectRoleManager projectRoleManager, CommentService commentService, UserUtil userUtil, RemoteIssueLinkService remoteIssueLinkService) {
        super(issueLinkManager, subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil);
        this.remoteIssueLinkService = remoteIssueLinkService;
    }

    @Override
    protected void doValidation() {
        super.doValidation();
        RemoteIssueLink remoteIssueLink = new RemoteIssueLinkBuilder().issueId(this.getIssue().getLong("id")).url(this.url).title(this.title).build();
        this.validationResult = this.remoteIssueLinkService.validateCreate(this.getLoggedInUser(), remoteIssueLink);
        if (!this.validationResult.isValid()) {
            this.addErrorCollection(this.validationResult.getErrorCollection());
        }
    }

    public String doDefault() throws Exception {
        this.url = "http://";
        try {
            this.getIssueObject();
        }
        catch (IssueNotFoundException e) {
            return "error";
        }
        catch (IssuePermissionException e) {
            return "error";
        }
        return super.doDefault();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        try {
            RemoteIssueLinkService.RemoteIssueLinkResult result = this.remoteIssueLinkService.create(this.getLoggedInUser(), this.validationResult);
            if (result.isValid()) {
                this.createComment(this.getIssueObject());
                this.getIssueObject().resetModifiedFields();
            } else {
                this.addErrorCollection(result.getErrorCollection());
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error occurred creating link: " + e), (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.issues.an.error.occured", e));
        }
        if (this.isInlineDialogMode()) {
            return this.returnCompleteWithInlineRedirect("/browse/" + this.getIssue().getString("key") + "#linkingmodule");
        }
        return this.returnComplete("/browse/" + this.getIssue().getString("key") + "#linkingmodule");
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>(super.getDisplayParams());
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

