/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.browser;

import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugin.TabPanelModuleDescriptor;
import com.atlassian.jira.plugin.browsepanel.TabPanel;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanel;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.plugin.webresource.SuperBatchFilteringWriter;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.project.browse.BrowseProjectContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.action.util.PopularIssueTypesUtil;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import webwork.action.ActionContext;

public class BrowseProject
extends ProjectActionSupport {
    private static final String COKE_TAB_PANEL_NAME = "coke";
    protected final PluginAccessor pluginAccessor;
    private final WebResourceManager webResourceManager;
    private final PopularIssueTypesUtil popularIssueTypesUtil;
    private final UserProjectHistoryManager projectHistoryManager;
    private List<ProjectTabPanelModuleDescriptor> projectTabPanels;
    private boolean contentOnly = false;
    private Long projectId;
    private boolean noTitle = false;
    private static final String NO_TITLE = "noTitle";
    private PopularIssueTypesUtil.PopularIssueTypesHolder issueTypesHolder;
    private boolean stateUpdateOnly = false;
    private static final String STATEUPDATE = "stateupdate";
    private static final String CONTENTONLY = "contentonly";

    public BrowseProject(ProjectManager projectManager, PermissionManager permissionManager, PluginAccessor pluginAccessor, WebResourceManager webResourceManager, PopularIssueTypesUtil popularIssueTypesUtil, UserProjectHistoryManager projectHistoryManager) {
        super(projectManager, permissionManager);
        this.pluginAccessor = pluginAccessor;
        this.webResourceManager = webResourceManager;
        this.popularIssueTypesUtil = popularIssueTypesUtil;
        this.projectHistoryManager = projectHistoryManager;
    }

    public Long getId() {
        return this.projectId;
    }

    public void setId(Long id) {
        this.projectId = id;
        this.setSelectedProjectId(id);
    }

    public String getSelected() {
        String currentKey = (String)this.getSession().get("jira.project.browser.report");
        if (this.canSeeTab(currentKey)) {
            return currentKey;
        }
        List<ProjectTabPanelModuleDescriptor> projectTabPanels = this.getProjectTabPanels();
        if (!projectTabPanels.isEmpty()) {
            String key = projectTabPanels.get(0).getCompleteKey();
            this.getSession().put("jira.project.browser.report", key);
            return key;
        }
        return null;
    }

    private boolean canSeeTab(String tabKey) {
        if (tabKey == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(tabKey, ":");
        if (st.countTokens() == 2) {
            st.nextToken();
            String tabName = st.nextToken();
            for (ProjectTabPanelModuleDescriptor projectTabPanelModuleDescriptor : this.getProjectTabPanels()) {
                if (tabName == null || !tabName.equals(projectTabPanelModuleDescriptor.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    protected Map<String, Object> getSession() {
        return ActionContext.getSession();
    }

    public void setSelectedTab(String report) {
        this.getSession().put("jira.project.browser.report", report);
    }

    public void setStateUpdateOnly(boolean stateUpdateOnly) {
        this.stateUpdateOnly = stateUpdateOnly;
    }

    public boolean isStateUpdateOnly() {
        return this.stateUpdateOnly;
    }

    public Project getProject() {
        return this.projectHistoryManager.getCurrentProject(10, this.getLoggedInUser());
    }

    public boolean isHasProjectAdminPermission() {
        return this.getPermissionManager().hasPermission(23, this.getProject(), this.getLoggedInUser());
    }

    public String doExecute() throws Exception {
        try {
            Collection projects;
            Project newProject;
            Project project = this.getProject();
            if (this.projectId != null && (newProject = this.projectManager.getProjectObj(this.projectId)) != null && !newProject.equals(project)) {
                this.log.info((Object)"Specified project id to browse, but it is diff to current project.  Most prob a permission violation (or it doesn't exist)");
                return "permissionviolation";
            }
            if (project == null && (projects = this.getBrowsableProjects()).size() == 1) {
                Project onlyProject = (Project)projects.iterator().next();
                this.setSelectedProject(onlyProject);
            }
            if (this.getProject() == null) {
                return this.getRedirect("/secure/BrowseProjects.jspa");
            }
            if (!this.contentOnly) {
                this.webResourceManager.requireResource("jira.webresources:ajaxhistory");
                this.webResourceManager.requireResource("jira.webresources:browseproject");
            }
            if (this.stateUpdateOnly) {
                return STATEUPDATE;
            }
            if (this.contentOnly) {
                return CONTENTONLY;
            }
        }
        catch (IllegalStateException e) {
            this.log.info((Object)"Permissions Exception whilst browsing project", (Throwable)e);
            return "permissionviolation";
        }
        return "success";
    }

    public boolean hasCreateIssuePermissionForProject() {
        return this.getPermissionManager().hasPermission(11, this.getProject(), this.getLoggedInUser());
    }

    public List<ProjectTabPanelModuleDescriptor> getProjectTabPanels() {
        if (this.projectTabPanels == null) {
            this.projectTabPanels = this.initTabPanels(ProjectTabPanelModuleDescriptor.class);
        }
        return this.projectTabPanels;
    }

    public String getTabHtmlForJSON() throws IOException {
        String tabPanelHTML = this.getTabHtml();
        return JSONEscaper.escape((String)tabPanelHTML);
    }

    public String getTabHtml() throws IOException {
        String selectedTab = this.getSelected();
        if (selectedTab == null) {
            this.log.warn((Object)"Either unknown tab specified or no tab specfied and no tabs in system");
            return "";
        }
        ModuleDescriptor tabPanelDescriptor = this.pluginAccessor.getEnabledPluginModule(selectedTab);
        if (tabPanelDescriptor == null) {
            this.log.warn((Object)("Unknown tab panel '" + selectedTab + "' has been specified."));
            return "";
        }
        if (!(tabPanelDescriptor instanceof ProjectTabPanelModuleDescriptor)) {
            this.log.warn((Object)("Incorrect plugin module type '" + selectedTab + "' has been specified."));
            return "";
        }
        ProjectTabPanel panel = (ProjectTabPanel)tabPanelDescriptor.getModule();
        if (panel.showPanel(this.getBrowseContext())) {
            boolean descriptorNoTitle;
            String tabHtml = panel.getHtml(this.getBrowseContext());
            StringBuilder strBuilder = new StringBuilder();
            if (this.isContentOnly()) {
                SuperBatchFilteringWriter writer = new SuperBatchFilteringWriter();
                this.webResourceManager.includeResources((Writer)writer, UrlMode.AUTO);
                strBuilder.append(writer.toString());
            }
            boolean bl = descriptorNoTitle = tabPanelDescriptor.getParams().containsKey(NO_TITLE) && "true".equalsIgnoreCase((String)tabPanelDescriptor.getParams().get(NO_TITLE));
            if (!this.isNoTitle() && !descriptorNoTitle) {
                strBuilder.append("<h2>");
                strBuilder.append(this.getTabLabel());
                strBuilder.append("</h2>\n");
            }
            strBuilder.append(tabHtml);
            return strBuilder.toString();
        }
        this.log.warn((Object)"Tab panel should be hidden.");
        return "";
    }

    public String getTabLabel() {
        String selectedTab = this.getSelected();
        if (selectedTab == null) {
            this.log.warn((Object)"Either unknown tab specified or no tab specfied and no tabs in system");
            return "";
        }
        ProjectTabPanelModuleDescriptor tabPanelDescriptor = (ProjectTabPanelModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(selectedTab);
        return tabPanelDescriptor.getLabel();
    }

    public void setContentOnly(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }

    public boolean isContentOnly() {
        return this.contentOnly;
    }

    public boolean isNoTitle() {
        return this.noTitle;
    }

    public void setNoTitle(boolean noTitle) {
        this.noTitle = noTitle;
    }

    private PopularIssueTypesUtil.PopularIssueTypesHolder getIssueTypesHolder() {
        if (this.issueTypesHolder == null) {
            this.issueTypesHolder = this.popularIssueTypesUtil.getPopularAndOtherIssueTypesForProject(this.getProject(), this.getLoggedInUser());
        }
        return this.issueTypesHolder;
    }

    public Collection<IssueType> getPopularIssueTypes() {
        return this.getIssueTypesHolder().getPopularIssueTypes();
    }

    public Collection<IssueType> getOtherIssueTypes() {
        return this.getIssueTypesHolder().getOtherIssueTypes();
    }

    protected List<ProjectTabPanelModuleDescriptor> initTabPanels(Class tabPanelClass) {
        ArrayList<ProjectTabPanelModuleDescriptor> tabPanels;
        try {
            tabPanels = new ArrayList<ProjectTabPanelModuleDescriptor>(this.pluginAccessor.getEnabledModuleDescriptorsByClass(tabPanelClass));
            Iterator iterator = tabPanels.iterator();
            while (iterator.hasNext()) {
                ProjectTabPanelModuleDescriptor descriptor = (ProjectTabPanelModuleDescriptor)iterator.next();
                if (!this.isTabPanelHidden((TabPanelModuleDescriptor<? extends TabPanel>)descriptor)) continue;
                iterator.remove();
            }
        }
        catch (PermissionException e) {
            throw new RuntimeException(e);
        }
        Collections.sort(tabPanels, ModuleDescriptorComparator.COMPARATOR);
        return tabPanels;
    }

    protected boolean isTabPanelHidden(TabPanelModuleDescriptor<? extends TabPanel> descriptor) throws PermissionException {
        return !((TabPanel)descriptor.getModule()).showPanel(this.getBrowseContext());
    }

    private BrowseContext getBrowseContext() {
        return new BrowseProjectContext(this.getLoggedInUser(), this.getProject());
    }
}

