/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow.scheme;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.web.action.admin.workflow.scheme.SchemeAwareWorkflowAction;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.ofbiz.core.entity.GenericEntityException;

@WebSudoRequired
public class AddWorkflowSchemeEntity
extends SchemeAwareWorkflowAction {
    private String type;
    private String workflow;

    @Override
    public SchemeManager getSchemeManager() {
        return ManagerFactory.getWorkflowSchemeManager();
    }

    @Override
    public String getRedirectURL() {
        return "EditWorkflowSchemeEntities!default.jspa?schemeId=";
    }

    protected void doValidation() {
        try {
            if (this.getSchemeId() == null || this.getScheme() == null) {
                this.addErrorMessage(this.getText("admin.errors.workflows.must.select.scheme"));
            }
            if (!TextUtils.stringSet((String)this.workflow)) {
                this.addError("workflowname", this.getText("admin.errors.workflows.must.select.workflow.to.assign"));
            }
            if (!TextUtils.stringSet((String)this.getType())) {
                this.addErrorMessage(this.getText("admin.errors.workflows.must.select.type"));
            }
        }
        catch (GenericEntityException e) {
            this.addErrorMessage(this.getText("admin.errors.workflows.error.occured", e.getMessage()));
        }
    }

    protected String doExecute() throws Exception {
        ManagerFactory.getWorkflowSchemeManager().addWorkflowToScheme(this.getScheme(), this.getWorkflow(), this.getType());
        return this.getRedirect(this.getRedirectURL() + this.getSchemeId());
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map getIssueTypes() throws GenericEntityException {
        ListOrderedMap types = new ListOrderedMap();
        if (this.getSchemeManager().getEntities(this.getScheme(), "0").size() == 0) {
            types.put("0", this.getText("admin.schemes.workflows.all.unassigned"));
        }
        for (IssueType issueType : this.getConstantsManager().getRegularIssueTypeObjects()) {
            if (this.getSchemeManager().getEntities(this.getScheme(), issueType.getId()).size() != 0) continue;
            types.put(issueType.getId(), issueType.getNameTranslation());
        }
        if (ComponentManager.getInstance().getSubTaskManager().isSubTasksEnabled()) {
            for (IssueType subTaskType : this.getConstantsManager().getSubTaskIssueTypeObjects()) {
                if (this.getSchemeManager().getEntities(this.getScheme(), subTaskType.getId()).size() != 0) continue;
                types.put(subTaskType.getId(), subTaskType.getNameTranslation());
            }
        }
        return types;
    }

    public Collection getWorkflows() throws WorkflowException {
        return ManagerFactory.getWorkflowManager().getWorkflows();
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(String workflow) {
        this.workflow = workflow;
    }
}

