/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.InfrastructureException;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowModuleDescriptor;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowTransitionAction;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import webwork.action.ActionContext;

public abstract class AbstractAddWorkflowTransitionDescriptorParams
extends AbstractWorkflowTransitionAction {
    private String pluginModuleKey;
    private Map descriptorParams;
    private AbstractWorkflowModuleDescriptor descriptor;

    public AbstractAddWorkflowTransitionDescriptorParams(JiraWorkflow workflow, StepDescriptor step, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService) {
        super(workflow, step, transition, pluginAccessor, workflowService);
    }

    public AbstractAddWorkflowTransitionDescriptorParams(JiraWorkflow workflow, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService) {
        super(workflow, transition, pluginAccessor, workflowService);
    }

    public String doDefault() throws Exception {
        this.setupDescriptor();
        ResourceDescriptor parametersResourceDescriptor = this.getParametersResourceDescriptor(this.descriptor);
        if (parametersResourceDescriptor == null) {
            this.descriptorParams = Collections.EMPTY_MAP;
            return this.doExecute();
        }
        return super.doDefault();
    }

    protected void doValidation() {
        this.setupDescriptor();
        this.setupWorkflowDescriptorParams(ActionContext.getParameters());
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.addWorkflowDescriptor();
        return this.getRedirect(this.getRedirectUrl());
    }

    protected String getRedirectUrl() {
        if (this.getStep() == null) {
            return "ViewWorkflowTransition.jspa?workflowName=" + URLEncoder.encode(this.getWorkflow().getName()) + "&workflowMode=" + this.getWorkflow().getMode() + "&workflowTransition=" + this.getTransition().getId();
        }
        return "ViewWorkflowTransition.jspa?workflowName=" + URLEncoder.encode(this.getWorkflow().getName()) + "&workflowMode=" + this.getWorkflow().getMode() + "&workflowStep=" + this.getStep().getId() + "&workflowTransition=" + this.getTransition().getId();
    }

    public String getPluginModuleKey() {
        return this.pluginModuleKey;
    }

    public void setPluginModuleKey(String pluginModuleKey) {
        this.pluginModuleKey = pluginModuleKey;
    }

    protected void setupWorkflowDescriptorParams(Map startingParams) {
        this.descriptorParams = new HashMap(startingParams);
        this.removeKeyOrAddError(this.descriptorParams, "workflowName", "admin.errors.workflows.cannot.find.name");
        this.removeKeyOrAddError(this.descriptorParams, "workflowStep", "admin.errors.workflows.cannot.find.step");
        this.removeKeyOrAddError(this.descriptorParams, "workflowTransition", "admin.errors.workflows.cannot.find.transition");
        this.removeKeyOrAddError(this.descriptorParams, "pluginModuleKey", "admin.errors.workflows.cannot.find.cannot.find.plugin.module.key");
        this.removeKeyOrAddError(this.descriptorParams, "count", "admin.errors.workflows.cannot.find.count");
        this.removeKeyOrAddError(this.descriptorParams, "nested", "admin.errors.workflows.cannot.find.nested");
        this.descriptorParams.remove("Add");
    }

    protected void setupDescriptor() {
        ModuleDescriptor pluginModuleDescriptor = this.getPluginAccessor().getPluginModule(this.pluginModuleKey);
        if (!this.getWorkflowModuleDescriptorClass().isInstance(pluginModuleDescriptor)) {
            throw new InfrastructureException("Module descriptor for '" + this.pluginModuleKey + "' is not a " + this.getWorkflowModuleDescriptorClass().getName() + ".");
        }
        this.descriptor = (AbstractWorkflowModuleDescriptor)pluginModuleDescriptor;
    }

    private ResourceDescriptor getParametersResourceDescriptor(AbstractWorkflowModuleDescriptor descriptor) {
        List resourceDescriptors = descriptor.getResourceDescriptors();
        for (ResourceDescriptor resourceDescriptor : resourceDescriptors) {
            if (!"input-parameters".equals(resourceDescriptor.getName())) continue;
            return resourceDescriptor;
        }
        return null;
    }

    protected Map getDescriptorParams() {
        return this.descriptorParams;
    }

    protected AbstractWorkflowModuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    public List getWorkflowModuleDescriptors() {
        return this.getPluginAccessor().getEnabledModuleDescriptorsByClass(this.getWorkflowModuleDescriptorClass());
    }

    public String getDescriptorHtml() {
        return this.descriptor.getHtml("input-parameters", null);
    }

    protected abstract Class getWorkflowModuleDescriptorClass();

    protected abstract void addWorkflowDescriptor() throws WorkflowException, PluginParseException;

    public abstract String getWorkflowDescriptorName();
}

