/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowModuleDescriptor;
import com.atlassian.jira.web.action.admin.workflow.AbstractWorkflowTransitionAction;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractAddWorkflowTransitionDescriptor
extends AbstractWorkflowTransitionAction {
    String type;

    public AbstractAddWorkflowTransitionDescriptor(JiraWorkflow workflow, StepDescriptor step, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService) {
        super(workflow, step, transition, pluginAccessor, workflowService);
    }

    public AbstractAddWorkflowTransitionDescriptor(JiraWorkflow workflow, ActionDescriptor transition, PluginAccessor pluginAccessor, WorkflowService workflowService) {
        super(workflow, transition, pluginAccessor, workflowService);
    }

    protected void doValidation() {
        if (!TextUtils.stringSet((String)this.type)) {
            this.addErrorMessage(this.getText("admin.errors.workflows.you.must.select.type", this.getText(this.getDescriptorNameKey())));
        }
    }

    protected String doExecute() throws Exception {
        return this.getRedirect(this.getRedirectUrl());
    }

    protected String getRedirectUrl() {
        if (this.getStep() == null) {
            return this.getParamsActionName() + "?workflowName=" + URLEncoder.encode(this.getWorkflow().getName()) + "&workflowMode=" + this.getWorkflow().getMode() + "&workflowTransition=" + this.getTransition().getId() + "&pluginModuleKey=" + URLEncoder.encode(this.type);
        }
        return this.getParamsActionName() + "?workflowName=" + URLEncoder.encode(this.getWorkflow().getName()) + "&workflowMode=" + this.getWorkflow().getMode() + "&workflowStep=" + this.getStep().getId() + "&workflowTransition=" + this.getTransition().getId() + "&pluginModuleKey=" + URLEncoder.encode(this.type);
    }

    public List getWorkflowModuleDescriptors() throws PluginParseException {
        List moduleDescriptors = this.getPluginAccessor().getEnabledModuleDescriptorsByType(this.getWorkflowModuleDescriptorType());
        Iterator iterator = moduleDescriptors.iterator();
        while (iterator.hasNext()) {
            AbstractWorkflowModuleDescriptor abstractWorkflowModuleDescriptor = (AbstractWorkflowModuleDescriptor)iterator.next();
            if (abstractWorkflowModuleDescriptor.isUnique() && this.isModulePresent(abstractWorkflowModuleDescriptor.getImplementationClass())) {
                iterator.remove();
                continue;
            }
            if (abstractWorkflowModuleDescriptor.isAddable(this.getWorkflow().getActionType(this.getTransition()))) continue;
            iterator.remove();
        }
        Collections.sort(moduleDescriptors);
        return moduleDescriptors;
    }

    protected abstract String getWorkflowModuleDescriptorType();

    public abstract String getDescriptorNameKey();

    protected abstract String getParamsActionName();

    protected abstract boolean isModulePresent(Class var1);

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

