/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.task;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Collection;
import webwork.action.ActionContext;

@WebSudoRequired
public class TaskAdmin
extends JiraWebActionSupport {
    private final Collection allTasks;
    private final long liveTaskCount;

    public TaskAdmin(TaskManager taskManager, OutlookDateManager outlookDateManager, JiraAuthenticationContext authenticationContext) {
        Collection<TaskDescriptor<?>> rawTasks = taskManager.getAllTasks();
        int liveTaskCount = 0;
        this.allTasks = new ArrayList();
        for (TaskDescriptor<?> taskDescriptor : rawTasks) {
            if (!taskDescriptor.isFinished()) {
                ++liveTaskCount;
            }
            TaskDescriptorBean taskDescriptorBean = new TaskDescriptorBean(taskDescriptor, authenticationContext.getI18nHelper(), outlookDateManager, authenticationContext.getUser());
            this.allTasks.add(taskDescriptorBean);
        }
        this.liveTaskCount = liveTaskCount;
    }

    public Collection getAllTasks() {
        return this.allTasks;
    }

    public boolean isHasLiveTasks() {
        return this.liveTaskCount > 0L;
    }

    public String getAcknowledgementURL(TaskDescriptorBean task) {
        String contextPath = ActionContext.getRequest().getContextPath();
        StringBuffer sb = new StringBuffer();
        sb.append(contextPath);
        sb.append("/");
        sb.append("secure/admin/jira/AcknowledgeTask.jspa?taskId=");
        sb.append(task.getTaskId());
        sb.append("&destinationURL=");
        sb.append("secure/admin/jira/TaskAdmin.jspa");
        return sb.toString();
    }
}

