/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.mail;

import com.atlassian.gzipfilter.org.apache.commons.lang.exception.ExceptionUtils;
import com.atlassian.jira.web.action.admin.mail.VerifyMailServerConnection;
import com.atlassian.mail.MailConstants;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mail.server.impl.SMTPMailServerImpl;
import com.opensymphony.util.TextUtils;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import org.apache.commons.lang.StringUtils;

public class VerifySmtpServerConnection
extends VerifyMailServerConnection {
    @Override
    protected String doExecute() throws Exception {
        SMTPMailServerImpl mailServer = null;
        String port = this.getPort();
        String protocol = this.getProtocol();
        verifyTimeout = this.getTimeout() == null || this.getTimeout() <= 0L ? 10000L : this.getTimeout();
        MailProtocol mailProtocol = StringUtils.isNotBlank((String)protocol) ? MailProtocol.getMailProtocol((String)protocol.trim()) : MailConstants.DEFAULT_SMTP_PROTOCOL;
        port = StringUtils.isNotBlank((String)port) ? port.trim() : mailProtocol.getDefaultPort();
        mailServer = TextUtils.stringSet((String)this.getJndiLocation()) ? new SMTPMailServerImpl(null, this.getName(), this.getDescription(), this.getFrom(), this.getPrefix(), true, mailProtocol, this.getJndiLocation(), port, this.isTlsRequired(), this.getUsername(), this.getPassword(), verifyTimeout) : new SMTPMailServerImpl(null, this.getName(), this.getDescription(), this.getFrom(), this.getPrefix(), false, mailProtocol, this.getServerName(), port, this.isTlsRequired(), this.getUsername(), this.getPassword(), verifyTimeout);
        this.validateServer((MailServer)mailServer, new VerifySmptServer());
        return "success";
    }

    public String doAdd() throws Exception {
        this.doVerification();
        return "add";
    }

    private void doVerification() throws Exception {
        this.doValidation();
        if (!this.hasAnyErrors()) {
            this.doExecute();
        }
    }

    public String doUpdate() throws Exception {
        this.doVerification();
        return "update";
    }

    public String doSetup() throws Exception {
        this.doVerification();
        return "setup";
    }

    public boolean isAnonymous() {
        return StringUtils.isBlank((String)this.getUsername()) && StringUtils.isBlank((String)this.getJndiLocation());
    }

    static class VerifySmptServer
    extends VerifyMailServerConnection.VerifyMailServer {
        VerifySmptServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void verifyMailServer(MailServer server) {
            Transport transport = null;
            try {
                Session session = server.getSession();
                if (session != null) {
                    this.addTimeouts(session, server);
                    SMTPMailServer smtpServer = (SMTPMailServer)server;
                    transport = session.getTransport();
                    if (smtpServer.isSessionServer()) {
                        transport.connect();
                        if (!transport.isConnected()) {
                            this.errors.add(this.getI18nHelper().getText("admin.mailservers.mail.bad.jndisession"));
                            log.error((Object)String.format("Unable to connect to %s specified in JNDI", smtpServer.getJndiLocation()));
                        }
                    } else {
                        transport.connect(server.getHostname(), Integer.parseInt(server.getPort()), server.getUsername(), server.getPassword());
                        if (!transport.isConnected()) {
                            this.errors.add(this.getI18nHelper().getText("admin.mailservers.mail.bad.authentication"));
                            log.error((Object)String.format("Unable to authenticate to %s", smtpServer.getHostname()));
                        }
                    }
                } else {
                    this.errors.add(this.getI18nHelper().getText("admin.mailservers.mail.bad.session"));
                    log.error((Object)"Unable to retrieve a seesion from the SMTP mail server");
                }
            }
            catch (Exception e) {
                Throwable t = ExceptionUtils.getRootCause((Throwable)e) != null ? ExceptionUtils.getRootCause((Throwable)e) : e;
                this.errors.add(String.format("%s: %s", t.getClass().getSimpleName(), t.getMessage()));
                log.error((Object)String.format("Unable to connect to the server at %s due to the following exception: %s", server.getHostname(), t.toString()));
            }
            finally {
                if (transport != null) {
                    try {
                        transport.close();
                    }
                    catch (MessagingException ignore) {
                        log.error((Object)("Exception when closing transport " + ignore.getMessage()));
                    }
                }
            }
        }

        private void addTimeouts(Session session, MailServer server) {
            Properties p = session.getProperties();
            String protocol = p.getProperty("mail.transport.protocol");
            String connectionTimeout = String.format("mail.%s.connectiontimeout", protocol);
            String socketTimeout = String.format("mail.%s.timeout", protocol);
            p.setProperty(connectionTimeout, "" + VerifyMailServerConnection.verifyTimeout);
            p.setProperty(socketTimeout, "" + VerifyMailServerConnection.verifyTimeout);
        }
    }
}

