/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.mail;

import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.mail.MailServerActionSupport;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;

@WebSudoRequired
public class DeleteMailServer
extends MailServerActionSupport {
    private boolean confirmed;
    private final MailServerManager mailServerManager;

    public DeleteMailServer(MailServerManager mailServerManager) {
        this.mailServerManager = mailServerManager;
    }

    @Override
    protected void doValidation() {
        if (this.getId() == null || !this.isConfirmed()) {
            this.addErrorMessage(this.getText("admin.errors.mail.confirm.deletion.of.server"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.canDeleteMailServer()) {
            this.mailServerManager.delete(this.getId());
            return this.getRedirect("ViewMailServers.jspa");
        }
        return "securitybreach";
    }

    private boolean canDeleteMailServer() throws MailException {
        MailServer mailServer = this.mailServerManager.getMailServer(this.getId());
        if (mailServer == null) {
            return false;
        }
        if (this.isPop(mailServer)) {
            return this.canManagePopMailServers();
        }
        if (this.isSmtp(mailServer)) {
            return this.canManageSmtpMailServers();
        }
        return false;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }
}

