/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.jira.web.action.admin.constants.AbstractDeleteConstant;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class DeleteIssueType
extends AbstractDeleteConstant {
    private final FieldLayoutManager fieldLayoutManager;
    private final ProjectManager projectManager;
    private final WorkflowManager workflowManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final CustomFieldManager customFieldManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private Collection availableIssueTypes;
    boolean defaultLayoutScheme = false;
    JiraWorkflow workflow = null;
    private FieldScreenScheme fieldScreenScheme;
    private Long fieldLayoutId;

    public DeleteIssueType(FieldLayoutManager fieldLayoutManager, ProjectManager projectManager, WorkflowManager workflowManager, WorkflowSchemeManager workflowSchemeManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, CustomFieldManager customFieldManager, IssueTypeSchemeManager issueTypeSchemeManager, FieldConfigSchemeManager fieldConfigSchemeManager) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.projectManager = projectManager;
        this.workflowManager = workflowManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.customFieldManager = customFieldManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
    }

    @Override
    protected String getConstantEntityName() {
        return "IssueType";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.issuetype.lowercase");
    }

    @Override
    protected String getIssueConstantField() {
        return "type";
    }

    @Override
    protected GenericValue getConstant(String id) {
        return this.getConstantsManager().getIssueType(id);
    }

    protected IssueType getIssueTypeObject() {
        return this.getConstantsManager().getIssueTypeObject(this.id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewIssueTypes.jspa";
    }

    @Override
    protected Collection<GenericValue> getConstants() {
        return this.getConstantsManager().getIssueTypes();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshIssueTypes();
        ManagerFactory.getFieldManager().refresh();
    }

    @Override
    protected void doValidation() {
        try {
            if (this.getMatchingIssues().isEmpty()) {
                if (this.getConstant() == null) {
                    this.addErrorMessage(this.getText("admin.errors.no.constant.found", this.getNiceConstantName(), this.id));
                }
            } else {
                if (this.getAvailableIssueTypes().isEmpty()) {
                    this.addErrorMessage(this.getText("admin.errors.issuetypes.no.alternative"));
                }
                super.doValidation();
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error occurred: " + e), (Throwable)e);
            this.addErrorMessage(this.getText("admin.errors.error.occurred") + " " + e);
        }
    }

    @Override
    protected String doExecute() throws Exception {
        List workflowSchemes = this.workflowSchemeManager.getSchemes();
        for (GenericValue workflowScheme : workflowSchemes) {
            List entities = this.workflowSchemeManager.getEntities(workflowScheme);
            for (GenericValue entity : entities) {
                if (!this.getId().equals(entity.getString("issuetype"))) continue;
                this.workflowSchemeManager.deleteEntity(entity.getLong("id"));
            }
        }
        for (FieldLayoutScheme fieldLayoutScheme : this.fieldLayoutManager.getFieldLayoutSchemes()) {
            if (!fieldLayoutScheme.containsEntity(this.getId())) continue;
            fieldLayoutScheme.removeEntity(this.getId());
        }
        for (IssueTypeScreenScheme issueTypeScreenScheme : this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes()) {
            if (!issueTypeScreenScheme.containsEntity(this.getId())) continue;
            issueTypeScreenScheme.removeEntity(this.getId());
        }
        this.fieldConfigSchemeManager.removeInvalidFieldConfigSchemesForIssueType(this.getIssueTypeObject());
        this.customFieldManager.refresh();
        this.issueTypeSchemeManager.removeOptionFromAllSchemes(this.getId());
        return super.doExecute();
    }

    public Collection getAvailableIssueTypes() throws GenericEntityException, WorkflowException {
        if (this.availableIssueTypes == null) {
            Collection projects = this.projectManager.getProjects();
            this.availableIssueTypes = new HashSet();
            if (!this.checkIssueTypeAssociations(projects)) {
                return Collections.EMPTY_LIST;
            }
            GenericValue issueType = this.getConstantsManager().getIssueType(this.getId());
            Collection issueTypes = this.getConstantsManager().getSubTaskIssueTypes().contains(issueType) ? this.getConstantsManager().getSubTaskIssueTypes() : this.getConstantsManager().getIssueTypes();
            this.availableIssueTypes = this.getAlternativeTypes(issueTypes, projects);
        }
        return this.availableIssueTypes;
    }

    private Map mapIdToType(Collection issueTypeGVs) {
        HashMap<String, GenericValue> map = new HashMap<String, GenericValue>();
        for (GenericValue gv : issueTypeGVs) {
            map.put(gv.getString("id"), gv);
        }
        return map;
    }

    private boolean checkIssueTypeAssociations(Collection projects) throws WorkflowException, GenericEntityException {
        for (GenericValue projectGV : projects) {
            if (this.workflow == null) {
                this.workflow = this.workflowManager.getWorkflow(projectGV.getLong("id"), this.getId());
                continue;
            }
            if (this.workflow.equals(this.workflowManager.getWorkflow(projectGV.getLong("id"), this.getId()))) continue;
            return false;
        }
        this.fieldLayoutId = null;
        int i = 0;
        for (FieldLayoutScheme layoutScheme : this.fieldLayoutManager.getFieldLayoutSchemes()) {
            if (layoutScheme.getProjects().isEmpty()) continue;
            if (i == 0) {
                this.fieldLayoutId = layoutScheme.getFieldLayoutId(this.getId());
                ++i;
                continue;
            }
            if (ObjectUtils.equalsNullSafe((Object)this.fieldLayoutId, (Object)layoutScheme.getFieldLayoutId(this.getId()))) continue;
            return false;
        }
        i = 0;
        for (IssueTypeScreenScheme issueTypeScreenScheme : this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes()) {
            if (issueTypeScreenScheme.getProjects().isEmpty()) continue;
            IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(this.getId());
            if (issueTypeScreenSchemeEntity == null) {
                issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(null);
            }
            if (i == 0) {
                this.fieldScreenScheme = issueTypeScreenSchemeEntity.getFieldScreenScheme();
                ++i;
                continue;
            }
            if (ObjectUtils.equalsNullSafe((Object)this.fieldScreenScheme, (Object)issueTypeScreenSchemeEntity.getFieldScreenScheme())) continue;
            return false;
        }
        return true;
    }

    private Collection getAlternativeTypes(Collection issueTypes, Collection projects) throws WorkflowException {
        GenericValue issueType2;
        HashSet<GenericValue> availableIssueTypes = new HashSet<GenericValue>();
        block0: for (GenericValue issueType2 : issueTypes) {
            if (this.getId().equals(issueType2.getString("id"))) continue;
            for (GenericValue projectGV : projects) {
                if (this.workflow.equals(this.workflowManager.getWorkflow(projectGV.getLong("id"), issueType2.getString("id")))) continue;
                continue block0;
            }
            availableIssueTypes.add(issueType2);
        }
        Iterator iterator = availableIssueTypes.iterator();
        block2: while (iterator.hasNext()) {
            issueType2 = (GenericValue)iterator.next();
            for (FieldLayoutScheme fieldLayoutScheme : this.fieldLayoutManager.getFieldLayoutSchemes()) {
                Long flid;
                if (fieldLayoutScheme.getProjects().isEmpty() || ObjectUtils.equalsNullSafe((Object)this.fieldLayoutId, (Object)(flid = fieldLayoutScheme.getFieldLayoutId(issueType2.getString("id"))))) continue;
                iterator.remove();
                continue block2;
            }
        }
        iterator = availableIssueTypes.iterator();
        block4: while (iterator.hasNext()) {
            issueType2 = (GenericValue)iterator.next();
            for (IssueTypeScreenScheme issueTypeScreenScheme : this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes()) {
                if (issueTypeScreenScheme.getProjects().isEmpty()) continue;
                IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(issueType2.getString("id"));
                if (issueTypeScreenSchemeEntity == null) {
                    issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(null);
                }
                if (ObjectUtils.equalsNullSafe((Object)this.fieldScreenScheme, (Object)issueTypeScreenSchemeEntity.getFieldScreenScheme())) continue;
                iterator.remove();
                continue block4;
            }
        }
        return availableIssueTypes;
    }
}

