/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.util.lang.JiraStringUtils;
import com.atlassian.jira.web.action.admin.issuefields.screens.AbstractFieldScreenAction;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

@WebSudoRequired
public class ViewFieldScreens
extends AbstractFieldScreenAction {
    private String confirm;
    private Map fieldScreenSchemeMap;
    private final FieldScreenSchemeManager fieldScreenSchemeManager;
    private final WorkflowManager workflowManager;

    public ViewFieldScreens(FieldScreenManager fieldScreenManager, FieldScreenSchemeManager fieldScreenSchemeManager, WorkflowManager workflowManager) {
        super(fieldScreenManager);
        this.fieldScreenSchemeManager = fieldScreenSchemeManager;
        this.workflowManager = workflowManager;
        this.fieldScreenSchemeMap = new HashMap();
    }

    protected String doExecute() throws Exception {
        return this.getResult();
    }

    public String doAddFieldScreen() {
        this.validateScreenName();
        if (!this.invalidInput()) {
            FieldScreenImpl fieldScreen = new FieldScreenImpl(this.fieldScreenManager);
            fieldScreen.setName(this.getFieldScreenName());
            fieldScreen.setDescription(this.getFieldScreenDescription());
            fieldScreen.store();
            fieldScreen.addTab(this.getText("'admin.field.screen.default'"));
            return this.redirectToView();
        }
        return this.getResult();
    }

    public String doDeleteFieldScreen() {
        this.validateId();
        if (!this.invalidInput() && !this.isDeletable(this.getFieldScreen())) {
            this.addErrorMessage(this.getText("admin.errors.screens.cannot.delete.screen.used.screen.schemes"));
        }
        if (!this.invalidInput() && !TextUtils.stringSet((String)this.confirm)) {
            return "confirm";
        }
        if (!this.invalidInput()) {
            if (Boolean.valueOf(this.getConfirm()).booleanValue()) {
                this.getFieldScreen().remove();
            }
            return this.redirectToView();
        }
        return this.getResult();
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public Collection getFieldScreenSchemes(FieldScreen fieldScreen) {
        if (!this.fieldScreenSchemeMap.containsKey(fieldScreen.getId())) {
            this.fieldScreenSchemeMap.put(fieldScreen.getId(), this.fieldScreenSchemeManager.getFieldScreenSchemes(fieldScreen));
        }
        return (Collection)this.fieldScreenSchemeMap.get(fieldScreen.getId());
    }

    public Map<JiraWorkflow, Collection<ActionDescriptor>> getWorkflows(FieldScreen fieldScreen) {
        TreeMap<JiraWorkflow, Collection<ActionDescriptor>> workflows = new TreeMap<JiraWorkflow, Collection<ActionDescriptor>>();
        for (JiraWorkflow workflow : this.workflowManager.getWorkflows()) {
            Collection actions = workflow.getActionsForScreen(fieldScreen);
            if (actions == null || actions.isEmpty()) continue;
            workflows.put(workflow, actions);
        }
        return workflows;
    }

    public Collection<WorkflowTransitionViewHelper> getWorkflowTransitionViews(FieldScreen fieldScreen) {
        ArrayList<WorkflowTransitionViewHelper> answer = new ArrayList<WorkflowTransitionViewHelper>();
        for (JiraWorkflow workflow : this.workflowManager.getWorkflows()) {
            Collection actions = workflow.getActionsForScreen(fieldScreen);
            if (actions == null || actions.isEmpty()) continue;
            for (ActionDescriptor action : actions) {
                answer.add(new WorkflowTransitionViewHelper(workflow, action));
            }
        }
        Collections.sort(answer);
        return answer;
    }

    private boolean hasWorkflowsIncludingDrafts(FieldScreen fieldScreen) {
        for (JiraWorkflow workflow : this.workflowManager.getWorkflowsIncludingDrafts()) {
            Collection actions = workflow.getActionsForScreen(fieldScreen);
            if (actions == null || actions.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isDeletable(FieldScreen fieldScreen) {
        return this.getFieldScreenSchemes(fieldScreen).isEmpty() && !this.hasWorkflowsIncludingDrafts(fieldScreen);
    }

    public static class WorkflowTransitionViewHelper
    implements Comparable<WorkflowTransitionViewHelper> {
        private final JiraWorkflow workflow;
        private final ActionDescriptor transition;
        private final Collection<StepDescriptor> steps;

        private WorkflowTransitionViewHelper(JiraWorkflow workflow, ActionDescriptor transition) {
            this.workflow = workflow;
            this.transition = transition;
            this.steps = this.initTransitionSteps();
        }

        private Collection<StepDescriptor> initTransitionSteps() {
            return this.workflow.getStepsForTransition(this.transition);
        }

        @Override
        public int compareTo(WorkflowTransitionViewHelper other) {
            return this.workflow.compareTo((Object)other.workflow);
        }

        public String getWorkflowName() {
            return this.workflow.getName();
        }

        public String getWorkflowMode() {
            return this.workflow.getMode();
        }

        public String getTransitionName() {
            return this.transition.getName();
        }

        public int transitionId() {
            return this.transition.getId();
        }

        public boolean hasSteps() {
            return !this.steps.isEmpty();
        }

        public StepDescriptor getFirstStep() {
            if (!this.hasSteps()) {
                throw new IllegalStateException("No steps for " + this);
            }
            return this.steps.iterator().next();
        }

        public boolean isGlobalAction() {
            return this.workflow.isGlobalAction(this.transition);
        }

        public String toString() {
            return JiraStringUtils.asString((Object[])new Object[]{"WorkflowTransition[Workflow=", this.workflow.getName(), ",transition=", this.transition.getId(), "]"});
        }
    }
}

