/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.web.action.admin.issuefields.screens.AbstractFieldScreenAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;

@WebSudoRequired
public class EditFieldScreen
extends AbstractFieldScreenAction {
    private boolean edited;

    public EditFieldScreen(FieldScreenManager fieldScreenManager) {
        super(fieldScreenManager);
    }

    public String doDefault() throws Exception {
        this.validateId();
        if (this.invalidInput()) {
            return "error";
        }
        this.setFieldScreenName(this.getFieldScreen().getName());
        this.setFieldScreenDescription(this.getFieldScreen().getDescription());
        return "input";
    }

    protected void doValidation() {
        this.validateId();
        if (!this.invalidInput()) {
            this.validateScreenName();
        }
    }

    protected String doExecute() throws Exception {
        this.getFieldScreen().setName(this.getFieldScreenName());
        this.getFieldScreen().setDescription(this.getFieldScreenDescription());
        this.getFieldScreen().store();
        return this.redirectToView();
    }

    public void setFieldScreen(FieldScreen fieldScreen) {
        this.fieldScreen = fieldScreen;
    }

    public String doCopyFieldScreen() {
        this.validateId();
        if (this.isEdited()) {
            if (!TextUtils.stringSet((String)this.getFieldScreenName())) {
                this.addError("fieldScreenName", this.getText("admin.common.errors.validname"));
            } else {
                for (FieldScreen fieldScreen : this.getFieldScreens()) {
                    if (!this.getFieldScreenName().equals(fieldScreen.getName())) continue;
                    this.addError("fieldScreenName", this.getText("admin.errors.screens.duplicate.screen.name"));
                }
            }
            if (!this.invalidInput()) {
                FieldScreenImpl fieldScreen = new FieldScreenImpl(this.getFieldScreenManager(), null);
                fieldScreen.setName(this.getFieldScreenName());
                fieldScreen.setDescription(this.getFieldScreenDescription());
                fieldScreen.store();
                for (FieldScreenTab fieldScreenTab : this.getFieldScreen().getTabs()) {
                    FieldScreenTab copyFieldScreenTab = fieldScreen.addTab(fieldScreenTab.getName());
                    for (FieldScreenLayoutItem fieldScreenLayoutItem : fieldScreenTab.getFieldScreenLayoutItems()) {
                        copyFieldScreenTab.addFieldScreenLayoutItem(fieldScreenLayoutItem.getFieldId());
                    }
                }
                return this.redirectToView();
            }
        } else {
            this.setFieldScreenName(this.getText("common.words.copyof", this.getFieldScreen().getName()));
            this.setFieldScreenDescription(this.getFieldScreen().getDescription());
            return "input";
        }
        return this.getResult();
    }

    public boolean isEdited() {
        return this.edited;
    }

    public void setEdited(boolean edited) {
        this.edited = edited;
    }
}

