/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayoutImpl;
import com.atlassian.jira.issue.fields.layout.field.FieldConfigurationScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.web.action.admin.issuefields.enterprise.AbstractFieldLayoutAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@WebSudoRequired
public class ViewFieldLayouts
extends AbstractFieldLayoutAction {
    private String confirm;
    private Map<Long, Collection<FieldConfigurationScheme>> fieldLayoutSchemeMap = new HashMap<Long, Collection<FieldConfigurationScheme>>();

    public ViewFieldLayouts(FieldLayoutManager fieldLayoutManager) {
        super(fieldLayoutManager);
    }

    protected String doExecute() throws Exception {
        return this.getResult();
    }

    public String doAddFieldLayout() {
        this.validateName();
        if (!this.invalidInput()) {
            for (EditableFieldLayout fieldLayout : this.getFieldLayouts()) {
                if (!this.getFieldLayoutName().equals(fieldLayout.getName())) continue;
                this.addError("fieldLayoutName", this.getText("admin.errors.fieldlayout.name.exists"));
                break;
            }
        }
        if (!this.invalidInput()) {
            EditableDefaultFieldLayout editableDefaultFieldLayout = this.getFieldLayoutManager().getEditableDefaultFieldLayout();
            EditableFieldLayoutImpl editableFieldLayout = new EditableFieldLayoutImpl(null, editableDefaultFieldLayout.getFieldLayoutItems());
            editableFieldLayout.setName(this.getFieldLayoutName());
            editableFieldLayout.setDescription(this.getFieldLayoutDescription());
            this.getFieldLayoutManager().storeEditableFieldLayout((EditableFieldLayout)editableFieldLayout);
            return this.redirectToView();
        }
        return this.getResult();
    }

    public String doDeleteFieldLayout() {
        this.validateId();
        if (!this.invalidInput()) {
            this.validateFieldLayout();
            if (!this.invalidInput()) {
                if (!Boolean.valueOf(this.getConfirm()).booleanValue()) {
                    return "confirm";
                }
                this.getFieldLayoutManager().deleteFieldLayout((FieldLayout)this.getFieldLayout());
                return this.redirectToView();
            }
        }
        return this.getResult();
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public String doEditFieldLayout() {
        this.validateId();
        if (!this.invalidInput()) {
            this.validateFieldLayout();
            if (!this.invalidInput()) {
                if (!Boolean.valueOf(this.getConfirm()).booleanValue()) {
                    return "confirm";
                }
                this.getFieldLayoutManager().deleteFieldLayout((FieldLayout)this.getFieldLayout());
                return this.redirectToView();
            }
        }
        return this.getResult();
    }

    public Collection<FieldConfigurationScheme> getFieldLayoutSchemes(EditableFieldLayout editableFieldLayout) {
        try {
            if (!this.fieldLayoutSchemeMap.containsKey(editableFieldLayout.getId())) {
                this.fieldLayoutSchemeMap.put(editableFieldLayout.getId(), this.getFieldLayoutManager().getFieldConfigurationSchemes((FieldLayout)editableFieldLayout));
            }
        }
        catch (Exception e) {
            this.log.error((Object)e);
        }
        return this.fieldLayoutSchemeMap.get(editableFieldLayout.getId());
    }
}

