/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.web.action.admin.issuefields.enterprise.AbstractEditFieldLayoutSchemeAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;

@WebSudoRequired
public class EditFieldLayoutScheme
extends AbstractEditFieldLayoutSchemeAction {
    private String confirm;

    public EditFieldLayoutScheme(FieldLayoutManager fieldLayoutManager) {
        super(fieldLayoutManager);
    }

    protected void doValidation() {
        this.validateName();
        if (!this.invalidInput()) {
            this.validateId();
            if (!this.invalidInput()) {
                for (FieldLayoutScheme fieldLayoutScheme : this.getFieldLayoutSchemes()) {
                    if (this.getId().equals(fieldLayoutScheme.getId()) || !this.getFieldLayoutSchemeName().equals(fieldLayoutScheme.getName())) continue;
                    this.addError("fieldLayoutSchemeName", this.getText("admin.errors.fieldlayout.scheme.name.exists"));
                }
                if (!this.invalidInput()) {
                    this.validateFieldLayoutScheme();
                }
            }
        }
    }

    protected String doExecute() throws Exception {
        this.getFieldLayoutScheme().setName(this.getFieldLayoutSchemeName());
        this.getFieldLayoutScheme().setDescription(this.getFieldLayoutSchemeDescription());
        this.getFieldLayoutScheme().store();
        return this.redirectToView();
    }

    public String doDeleteScheme() {
        this.validateId();
        if (!this.invalidInput()) {
            this.validateFieldLayoutScheme();
            if (!this.invalidInput()) {
                Collection schemeProjects = this.getSchemeProjects(this.getFieldLayoutScheme());
                if (schemeProjects != null && !schemeProjects.isEmpty()) {
                    this.addErrorMessage(this.getText("admin.errors.fieldlayout.cannot.delete"));
                }
                if (!this.invalidInput()) {
                    if (!Boolean.valueOf(this.getConfirm()).booleanValue()) {
                        return "confirm";
                    }
                    this.getFieldLayoutScheme().remove();
                    return this.redirectToView();
                }
            }
        }
        return this.getResult();
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    @Override
    protected String getInitialName() {
        return this.getFieldLayoutScheme().getName();
    }
}

