/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields;

import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.ArrayList;
import java.util.Collections;

public abstract class AbstractEditFieldLayoutItem
extends JiraWebActionSupport {
    private Integer position;
    private String description;
    private String fieldNameKey;
    protected static final String ACCESS_EXCEPTION = "Error while accessing field layouts.";

    public String doDefault() throws Exception {
        FieldLayoutItem fieldLayoutItem = this.getFieldLayoutItem();
        if (fieldLayoutItem != null) {
            this.setDescription(fieldLayoutItem.getFieldDescription());
            this.setFieldNameKey(fieldLayoutItem.getOrderableField().getNameKey());
        }
        return super.doDefault();
    }

    protected String doExecute() throws Exception {
        FieldLayoutItem fieldLayoutItem = this.getFieldLayoutItem();
        if (fieldLayoutItem != null) {
            this.getFieldLayout().setDescription(fieldLayoutItem, this.getDescription());
            this.store();
        }
        return this.getRedirect(this.getRedirectURI());
    }

    protected abstract String getRedirectURI();

    private FieldLayoutItem getFieldLayoutItem() {
        if (this.getPosition() != null) {
            ArrayList fieldLayoutItems = new ArrayList(this.getFieldLayout().getFieldLayoutItems());
            Collections.sort(fieldLayoutItems);
            if (this.getPosition() >= 0 && this.getPosition() < fieldLayoutItems.size()) {
                return (FieldLayoutItem)fieldLayoutItems.get(this.getPosition());
            }
            this.log.error((Object)("The field layout item at position '" + this.getPosition() + "' does not exist."));
            this.addErrorMessage(this.getText("admin.errors.fieldlayout.field.does.not.exist", "'" + this.getPosition() + "'"));
        }
        return null;
    }

    private void setFieldNameKey(String fieldNameKey) {
        this.fieldNameKey = fieldNameKey;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    protected abstract EditableFieldLayout getFieldLayout();

    protected abstract void store();

    public String getFieldNameKey() {
        return this.fieldNameKey;
    }
}

