/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.constants;

import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.web.action.admin.constants.AbstractConstantAction;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractViewConstants
extends AbstractConstantAction {
    private Map fields;
    String up;
    String down;
    String name;
    String description;
    String iconurl;
    String make;
    private static final Long NEW_STATUS_START_ID = 10000L;
    private final TranslationManager translationManager;

    protected AbstractViewConstants(TranslationManager translationManager) {
        this.translationManager = translationManager;
    }

    public String doAddConstant() throws Exception {
        this.validateName();
        if (this.invalidInput()) {
            return "error";
        }
        this.addConstant();
        return this.redirectToView();
    }

    protected void validateName() {
        if (!TextUtils.stringSet((String)this.name)) {
            this.addError("name", this.getText("admin.errors.must.specify.a.name.for.the.to.be.added", this.getNiceConstantName()));
        } else {
            for (GenericValue constantGv : this.getConstants()) {
                if (!this.name.trim().equalsIgnoreCase(constantGv.getString("name"))) continue;
                this.addError("name", this.getText("admin.errors.constant.already.exists", this.getNiceConstantName()));
                break;
            }
        }
    }

    protected GenericValue addConstant() throws GenericEntityException {
        String entityName = this.getConstantEntityName();
        if (TextUtils.stringSet((String)entityName)) {
            if (entityName.equals("Status") && Long.valueOf(EntityUtils.getNextStringId(entityName)) < NEW_STATUS_START_ID) {
                this.addField("id", NEW_STATUS_START_ID.toString());
            } else {
                this.addField("id", EntityUtils.getNextStringId(entityName));
            }
        } else {
            throw new IllegalArgumentException("Unable to create an entity without a valid name.");
        }
        this.addField("name", this.name);
        this.addField("description", this.description);
        this.addField("iconurl", this.iconurl);
        this.addField("sequence", new Long(this.getMaxSequenceNo() + 1L));
        GenericValue createdValue = EntityUtils.createValue(entityName, this.getFields());
        this.name = null;
        this.description = null;
        this.clearCaches();
        return createdValue;
    }

    protected abstract String redirectToView();

    private long getMaxSequenceNo() {
        long maxSequence = 0L;
        for (GenericValue constantGV : this.getConstants()) {
            long thisSequence = constantGV.getLong("sequence");
            if (thisSequence <= maxSequence) continue;
            maxSequence = thisSequence;
        }
        return maxSequence;
    }

    public String doMoveUp() {
        ArrayList<GenericValue> reordered = new ArrayList<GenericValue>();
        for (GenericValue value : this.getConstants()) {
            if (value.getString("id").equals(this.up) && reordered.size() == 0) {
                return "success";
            }
            if (value.getString("id").equals(this.up)) {
                reordered.add(reordered.size() - 1, value);
                continue;
            }
            reordered.add(value);
        }
        this.storeAndClearCaches(reordered);
        return this.getResult();
    }

    public String doMoveDown() {
        ArrayList<GenericValue> reordered = new ArrayList<GenericValue>();
        Iterator<GenericValue> iterator = this.getConstants().iterator();
        while (iterator.hasNext()) {
            GenericValue value = iterator.next();
            if (value.getString("id").equals(this.down) && !iterator.hasNext()) {
                return "success";
            }
            if (value.getString("id").equals(this.down)) {
                reordered.add(iterator.next());
                reordered.add(value);
                continue;
            }
            reordered.add(value);
        }
        this.storeAndClearCaches(reordered);
        return this.getResult();
    }

    public String doMakeDefault() throws Exception {
        this.getApplicationProperties().setString(this.getDefaultPropertyName(), this.make);
        return "success";
    }

    private void storeAndClearCaches(List reordered) throws DataAccessException {
        for (int i = 0; i < reordered.size(); ++i) {
            GenericValue value = (GenericValue)reordered.get(i);
            value.set("sequence", (Object)new Long(i + 1));
        }
        this.getOfBizDelegator().storeAll(reordered);
        this.clearCaches();
    }

    protected void addField(String key, Object value) {
        if (this.getFields() == null) {
            this.fields = new HashMap();
        }
        this.getFields().put(key, value);
    }

    private Map getFields() {
        return this.fields;
    }

    public boolean isDefault(GenericValue constant) {
        String constantId = this.getApplicationProperties().getString(this.getDefaultPropertyName());
        return constantId != null && constant.getString("id").equals(constantId);
    }

    protected abstract String getDefaultPropertyName();

    public void setUp(String up) {
        this.up = up;
    }

    public void setDown(String down) {
        this.down = down;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIconurl() {
        return this.iconurl;
    }

    public void setIconurl(String iconurl) {
        this.iconurl = iconurl;
    }

    public void setMake(String make) {
        this.make = make;
    }

    public boolean isTranslatable() {
        return !this.translationManager.getInstalledLocales().isEmpty();
    }
}

