/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;

@WebSudoRequired
public class TrackbackAdmin
extends ProjectActionSupport {
    private static final String ALL_ISSUES = "allIssues";
    private static final String PUBLIC_ISSUES_ONLY = "public";
    private static final String NO_OUTGOING_PINGS = "false";

    public TrackbackAdmin(ProjectManager projectManager, PermissionManager permissionManager) {
        super(projectManager, permissionManager);
    }

    public String doInitial() throws Exception {
        return "success";
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    public boolean isAcceptPings() {
        return this.getApplicationProperties().getOption("jira.option.trackback.receive");
    }

    public void setAcceptPings(boolean acceptPings) {
        this.getApplicationProperties().setOption("jira.option.trackback.receive", acceptPings);
    }

    public String getUrlExcludePattern() {
        return this.getApplicationProperties().getString("jira.trackback.exclude.pattern");
    }

    public void setUrlExcludePattern(String urlExcludePattern) {
        if (TextUtils.stringSet((String)urlExcludePattern)) {
            this.getApplicationProperties().setString("jira.trackback.exclude.pattern", urlExcludePattern);
        } else {
            this.getApplicationProperties().setString("jira.trackback.exclude.pattern", null);
        }
    }

    public String getSendPings() {
        boolean trackBackEnabled = this.getApplicationProperties().getOption("jira.option.trackback.send");
        if (trackBackEnabled) {
            boolean sendToPublicIssuesOnly = this.getApplicationProperties().getOption("jira.option.trackback.send.public");
            if (!sendToPublicIssuesOnly) {
                return ALL_ISSUES;
            }
            return PUBLIC_ISSUES_ONLY;
        }
        return NO_OUTGOING_PINGS;
    }

    public void setSendPings(String sendPingsStr) {
        if (NO_OUTGOING_PINGS.equals(sendPingsStr)) {
            this.getApplicationProperties().setOption("jira.option.trackback.send", false);
            this.getApplicationProperties().setOption("jira.option.trackback.send.public", false);
        } else if (ALL_ISSUES.equals(sendPingsStr)) {
            this.getApplicationProperties().setOption("jira.option.trackback.send", true);
            this.getApplicationProperties().setOption("jira.option.trackback.send.public", false);
        } else if (PUBLIC_ISSUES_ONLY.equals(sendPingsStr)) {
            this.getApplicationProperties().setOption("jira.option.trackback.send", true);
            this.getApplicationProperties().setOption("jira.option.trackback.send.public", true);
        }
    }
}

