/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.core.util.DataUtils;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.mail.util.ByteArrayDataSource;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.startup.PluginInfo;
import com.atlassian.jira.startup.PluginInfoProvider;
import com.atlassian.jira.startup.PluginInfos;
import com.atlassian.jira.util.FileFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.log.JiraLogLocator;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtils;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtilsImpl;
import com.atlassian.jira.util.system.check.SystemEnvironmentChecklist;
import com.atlassian.jira.util.system.patch.AppliedPatchInfo;
import com.atlassian.jira.util.system.patch.AppliedPatches;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class JiraSupportRequest
extends JiraWebActionSupport {
    private static final Logger LOG = Logger.getLogger(JiraSupportRequest.class);
    private static final String SUBJECT_PREFIX = "[JIRA Support Request]";
    private static final String JSR_VERSION_NAME = "X-JIRA-Support-Request-Version";
    private static final String JSR_VERSION = "1.0";
    private static final String JSR_PROPERTIES_NAME = "JiraSupportRequestProperties.properties";
    private static final String JSR_LEVEL_SEP = "_";
    private static final String VIEW_DONE = "done";
    private static final String EMAIL_TEMPLATES = "templates/email/";
    private static final String EMAIL_TEMPLATE = "text/jirasupportrequest.vm";
    private static final String PLUGIN_ENABLED_KEY = "admin.systeminfo.plugin.enabled";
    private static final String PLUGIN_DISABLED_KEY = "admin.systeminfo.plugin.disabled";
    private final ExtendedSystemInfoUtils systemInfoUtils;
    private final JiraLicenseService jiraLicenseService;
    private final JiraLogLocator locator;
    private final LocaleManager localeManager;
    private final FileFactory fileFactory;
    private String to;
    private String cc;
    private String subject;
    private boolean attachzipexport = false;
    private boolean attachLogs = false;
    private String description;
    private String supportIssueKey;
    private String invalidAddresses = null;
    private String name;
    private String email;
    private String phone;
    private List<String> warningMessages;
    private LicenseDetails licenseDetails;
    private final PluginInfoProvider pluginInfoProvider;

    public JiraSupportRequest(JiraLicenseService jiraLicenseService, JiraLogLocator locator, LocaleManager localeManager, FileFactory fileFactory, PluginInfoProvider pluginInfoProvider) {
        this(new ExtendedSystemInfoUtilsImpl(new I18nBean(Locale.ENGLISH)), jiraLicenseService, locator, localeManager, fileFactory, pluginInfoProvider);
    }

    protected JiraSupportRequest(ExtendedSystemInfoUtils extendedSystemInfoUtil, JiraLicenseService jiraLicenseService, JiraLogLocator locator, LocaleManager localeManager, FileFactory fileFactory, PluginInfoProvider pluginInfoProvider) {
        this.localeManager = localeManager;
        this.pluginInfoProvider = (PluginInfoProvider)Assertions.notNull((String)"pluginInfoProvider", (Object)pluginInfoProvider);
        this.systemInfoUtils = (ExtendedSystemInfoUtils)Assertions.notNull((String)"extendedSystemInfoUtil", (Object)extendedSystemInfoUtil);
        this.jiraLicenseService = (JiraLicenseService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.locator = (JiraLogLocator)Assertions.notNull((String)"locator", (Object)locator);
        this.fileFactory = (FileFactory)Assertions.notNull((String)"fileFactory", (Object)fileFactory);
        this.name = this.getLoggedInUser().getDisplayName();
        this.email = this.getLoggedInUser().getEmailAddress();
    }

    public String doDefault() throws Exception {
        if (!this.getLicenseDetails().isEntitledToSupport()) {
            return "nosupport";
        }
        ExternalLinkUtilImpl externalLinkUtil = new ExternalLinkUtilImpl();
        this.to = externalLinkUtil.getProperty("external.link.jira.support.mail.to");
        this.cc = this.getLoggedInUser().getEmailAddress();
        this.attachzipexport = true;
        this.attachLogs = true;
        return super.doDefault();
    }

    protected void doValidation() {
        LicenseDetails licenseDetails = this.getLicenseDetails();
        if (!licenseDetails.isEntitledToSupport()) {
            this.addErrorMessage(this.getText("admin.license.type.not.supported.error", licenseDetails.getDescription()));
        }
        if (!this.isHasMailServer()) {
            this.addErrorMessage(this.getText("admin.supportrequest.no.mailserver.configured"));
        }
        if (TextUtils.stringSet((String)this.to)) {
            this.addErrorIfEmailNotValid(this.to, "to", "admin.errors.must.specify.valid.to.address");
        } else {
            this.addError("to", this.getText("admin.errors.must.specify.at.least.one.to.address"));
        }
        if (TextUtils.stringSet((String)this.cc)) {
            this.addErrorIfEmailNotValid(this.cc, "cc", "admin.errors.must.specify.valid.cc.address");
        }
        this.addErrorIfStringNotSet(this.subject, "subject", "admin.errors.must.specify.subject");
        this.addErrorIfStringNotSet(this.description, "description", "admin.errors.must.specify.description");
        this.addErrorIfStringNotSet(this.name, "name", "admin.errors.must.specify.name");
        if (TextUtils.stringSet((String)this.email)) {
            this.addErrorIfEmailNotValid(this.email, "email", "admin.errors.must.specify.valid.contact.address");
        } else {
            this.addError("email", this.getText("admin.errors.must.specify.contact.email.address"));
        }
        super.doValidation();
    }

    private void addErrorIfStringNotSet(String string, String title, String messageKey) {
        if (!TextUtils.stringSet((String)string)) {
            this.addError(title, this.getText(messageKey));
        }
    }

    private void addErrorIfEmailNotValid(String email, String title, String messageKey) {
        StringTokenizer tokenzier = new StringTokenizer(email, ",");
        while (tokenzier.hasMoreTokens()) {
            String singleEmail = tokenzier.nextToken();
            if (TextUtils.verifyEmail((String)singleEmail)) continue;
            this.addError(title, this.getText(messageKey));
        }
    }

    protected String doExecute() throws Exception {
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        MimeMultipart multipart = new MimeMultipart();
        String baseURL = this.systemInfoUtils.getBaseUrl();
        String encoding = "UTF-8";
        contextParams.put("baseUrl", baseURL);
        contextParams.put("warningMessages", SystemEnvironmentChecklist.getEnglishWarningMessages());
        contextParams.put("appliedPatches", AppliedPatches.getAppliedPatches());
        contextParams.put("sysinfo", this.cloneNullSafe(this.systemInfoUtils.getProps()));
        contextParams.put("licenseinfo", this.systemInfoUtils.getLicenseInfo());
        contextParams.put("jvmstats", this.cloneNullSafe(this.systemInfoUtils.getJvmStats()));
        contextParams.put("memoryPools", this.systemInfoUtils.getMemoryPoolInformation());
        contextParams.put("buildstats", this.cloneNullSafe(this.systemInfoUtils.getBuildStats()));
        contextParams.put("commonConfig", this.cloneNullSafe(this.systemInfoUtils.getCommonConfigProperties()));
        contextParams.put("description", this.description);
        contextParams.put("name", this.getName());
        contextParams.put("email", this.getEmail());
        contextParams.put("phone", this.getPhone());
        contextParams.put("exportattached", this.attachzipexport);
        contextParams.put("listeners", this.getListenersForEmail());
        contextParams.put("services", this.getServicesForEmail());
        contextParams.put("plugins", this.getPluginsForEmail());
        contextParams.put("supportIssueKey", this.getSupportIssueKey());
        contextParams.put("installedLanguages", this.localeManager.getInstalledLocales());
        contextParams.put("defaultLanguage", this.systemInfoUtils.getDefaultLanguage());
        contextParams.put("isUsingSystemLocale", this.systemInfoUtils.isUsingSystemLocale());
        contextParams.put("paths", MapBuilder.newBuilder().add((Object)"JIRA Home", (Object)this.systemInfoUtils.getJiraHomeLocation()).add((Object)"Entity Engine", (Object)this.systemInfoUtils.getEntityEngineXmlPath()).add((Object)"Index", (Object)this.systemInfoUtils.getIndexLocation()).add((Object)"Logs", (Object)this.systemInfoUtils.getLogPath()).toMap());
        if (this.systemInfoUtils.getUsageStats() != null) {
            contextParams.put("usageStats", this.systemInfoUtils.getUsageStats());
        }
        multipart.addBodyPart(JiraSupportRequest.createAttachmentMimeBodyPart(JSR_PROPERTIES_NAME, this.persistProperties(contextParams)));
        contextParams.put("applicationPropertiesHTML", this.systemInfoUtils.getApplicationPropertiesFormatted("\n"));
        contextParams.put("systemPropertiesHTML", this.systemInfoUtils.getSystemPropertiesFormatted("\n"));
        String body = ManagerFactory.getVelocityManager().getEncodedBody(EMAIL_TEMPLATES, EMAIL_TEMPLATE, baseURL, "UTF-8", contextParams);
        com.atlassian.jira.mail.Email email = new com.atlassian.jira.mail.Email(this.to);
        email.setCc(this.cc);
        email.setSubject("[JIRA Support Request] " + this.subject);
        email.setBody(body);
        email.setMimeType("text/plain");
        email.setEncoding("UTF-8");
        email.setMultipart((Multipart)multipart);
        email.addHeader(JSR_VERSION_NAME, JSR_VERSION);
        if (!this.sendEmail(email)) {
            return "error";
        }
        return VIEW_DONE;
    }

    private static BodyPart createAttachmentMimeBodyPart(String attachmentName, DataSource dataSource) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        attachmentPart.setDataHandler(new DataHandler(dataSource));
        attachmentPart.setFileName(attachmentName);
        return attachmentPart;
    }

    DataSource persistProperties(Map srcMap) {
        ByteArrayDataSource byteArrayDataSource;
        Properties targetProperties = new Properties();
        this.copyProperties(srcMap, targetProperties, "");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = null;
        try {
            targetProperties.store(out, null);
            in = new ByteArrayInputStream(out.toByteArray());
            byteArrayDataSource = new ByteArrayDataSource(in, "text/plain");
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Problem creating support request properties file. How can this happen with a memory stream?");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((OutputStream)out);
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)in);
        return byteArrayDataSource;
    }

    private void copyProperties(Map<?, ?> srcMap, Properties targetProperties, String path) {
        for (Map.Entry<?, ?> entry : srcMap.entrySet()) {
            String key = this.getStringNotNull(entry.getKey());
            Object value = entry.getValue();
            this.copyProperty(targetProperties, path + key, value);
        }
    }

    boolean sendEmail(com.atlassian.jira.mail.Email email) {
        try {
            SingleMailQueueItem singleMailQueueItem = new SingleMailQueueItem((Email)email);
            singleMailQueueItem.send();
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to send Support Request", (Throwable)e);
            if (e.getCause() instanceof SendFailedException) {
                SendFailedException sfe = (SendFailedException)e.getCause();
                StringBuffer invalidAddressesSB = null;
                Address[] addresses = sfe.getInvalidAddresses();
                if (addresses != null) {
                    for (Address address : addresses) {
                        if (invalidAddressesSB == null) {
                            invalidAddressesSB = new StringBuffer(address.toString());
                            continue;
                        }
                        invalidAddressesSB.append(", ");
                        invalidAddressesSB.append(address.toString());
                    }
                    this.invalidAddresses = invalidAddressesSB == null ? null : invalidAddressesSB.toString();
                }
            }
            return false;
        }
        return true;
    }

    private void copyProperty(Properties targetProperties, String key, Object value) {
        if (value instanceof Map) {
            if (key.length() > 0) {
                key = key + JSR_LEVEL_SEP;
            }
            this.copyProperties((Map)value, targetProperties, key);
        } else if (value instanceof Collection) {
            if (key.length() > 0) {
                key = key + JSR_LEVEL_SEP;
            }
            int counter = 1;
            for (Object collectionValue : (Collection)value) {
                String childKey = key + String.valueOf(counter);
                this.copyProperty(targetProperties, childKey, collectionValue);
                ++counter;
            }
        } else {
            targetProperties.setProperty(key, this.getStringNotNull(value));
        }
    }

    private Collection getListenersForEmail() {
        Collection<GenericValue> listeners = this.systemInfoUtils.getListeners();
        ArrayList<String> listenerStrings = new ArrayList<String>(listeners.size());
        for (GenericValue gv : listeners) {
            StringBuffer sb = new StringBuffer();
            sb.append(gv.getString("name"));
            sb.append(" (");
            sb.append(gv.getString("clazz"));
            sb.append(")");
            PropertySet propertySet = OFBizPropertyUtils.getPropertySet(gv);
            Collection keys = propertySet.getKeys("", 5);
            if (keys != null && !keys.isEmpty()) {
                sb.append(" [");
                Iterator j = keys.iterator();
                while (j.hasNext()) {
                    String key = (String)j.next();
                    sb.append(key);
                    sb.append("=");
                    sb.append(propertySet.getString(key));
                    if (!j.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append("]");
            }
            listenerStrings.add(sb.toString());
        }
        return listenerStrings;
    }

    private Collection getServicesForEmail() {
        Collection<JiraServiceContainer> services = this.systemInfoUtils.getServices();
        ArrayList<String> serviceStrings = new ArrayList<String>(services.size());
        for (JiraServiceContainer service : services) {
            StringBuffer sb = new StringBuffer();
            sb.append(service.getName());
            sb.append(" (");
            sb.append(service.getServiceClass());
            sb.append(") : ");
            sb.append(this.systemInfoUtils.getMillisecondsToMinutes(service.getDelay()));
            sb.append("min ");
            try {
                this.appendAttributes(this.systemInfoUtils.getServicePropertyMap(service), sb);
            }
            catch (Exception ex) {
                LOG.debug((Object)"Error reading service properties", (Throwable)ex);
            }
            serviceStrings.add(sb.toString());
        }
        return serviceStrings;
    }

    private Collection<String> getPluginsForEmail() {
        ArrayList<String> pluginStrings = new ArrayList<String>();
        pluginStrings.add("");
        pluginStrings.add("----- User Installed Plugins ----------------------\n");
        this.addPluginInfo(this.pluginInfoProvider.getUserPlugins(), pluginStrings);
        pluginStrings.add("");
        pluginStrings.add("----- System Plugins ----------------------\n");
        this.addPluginInfo(this.pluginInfoProvider.getSystemPlugins(), pluginStrings);
        return pluginStrings;
    }

    private void addPluginInfo(PluginInfos plugins, Collection<String> pluginStrings) {
        for (PluginInfo plugin : plugins) {
            PluginInformation pluginInformation = plugin.getPluginInformation();
            StringBuffer sb = new StringBuffer();
            sb.append(plugin.getName());
            sb.append(" ");
            sb.append(pluginInformation.getVersion());
            this.appendAttributes(pluginInformation.getParameters(), sb);
            sb.append(" - ");
            sb.append(pluginInformation.getVendorName());
            sb.append(" : ");
            sb.append(this.getText(plugin.isEnabled() ? PLUGIN_ENABLED_KEY : PLUGIN_DISABLED_KEY));
            pluginStrings.add(sb.toString());
        }
    }

    protected String getTempFileName() throws IOException {
        this.fileFactory.getFile("temp");
        File file = File.createTempFile("export", "");
        String filename = file.getAbsolutePath();
        filename = DataUtils.getZipFilename((String)filename.trim());
        return filename;
    }

    public String getSupportRequestMessage() {
        return this.getLicenseDetails().getSupportRequestMessage((I18nHelper)this, this.getOutlookDate());
    }

    private LicenseDetails getLicenseDetails() {
        if (this.licenseDetails == null) {
            this.licenseDetails = this.jiraLicenseService.getLicense();
        }
        return this.licenseDetails;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getSubject() {
        return this.subject;
    }

    public boolean getAttachzipexport() {
        return this.attachzipexport;
    }

    public boolean isMailSendingDisabled() {
        return MailFactory.isSendingDisabled();
    }

    public boolean isHasMailServer() {
        try {
            return ComponentAccessor.getMailServerManager().getDefaultSMTPMailServer() != null;
        }
        catch (MailException e) {
            this.addErrorMessage(this.getText("admin.errors.retrieving.mail.server"));
            this.log.error((Object)"Error occurred while retrieving mail server information.", (Throwable)e);
            return false;
        }
    }

    public void setAttachzipexport(boolean attachzipexport) {
        this.attachzipexport = attachzipexport;
    }

    public boolean getAttachlogs() {
        return this.attachLogs;
    }

    public void setAttachlogs(boolean attachLogs) {
        this.attachLogs = attachLogs;
    }

    public String getLogPath() {
        return this.locator.findJiraLogFile().getAbsolutePath();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    private void appendAttributes(Map attributeMap, StringBuffer sb) {
        if (attributeMap != null && !attributeMap.isEmpty()) {
            sb.append(" [");
            Iterator j = attributeMap.entrySet().iterator();
            while (j.hasNext()) {
                Map.Entry entry = j.next();
                sb.append(entry.getKey());
                sb.append("=");
                sb.append(this.getText((String)entry.getValue()));
                if (!j.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
    }

    private Map<String, String> cloneNullSafe(Map<?, ?> map) {
        HashMap<String, String> retMap = new HashMap<String, String>(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = this.getStringNotNull(entry.getKey());
            String value = this.getStringNotNull(entry.getValue());
            retMap.put(key, value);
        }
        return retMap;
    }

    private String getStringNotNull(Object o) {
        return o == null ? "" : o.toString();
    }

    public String getSupportIssueKey() {
        return this.supportIssueKey;
    }

    public void setSupportIssueKey(String supportIssueKey) {
        this.supportIssueKey = supportIssueKey;
    }

    public String getInvalidAddresses() {
        return this.invalidAddresses;
    }

    public ExtendedSystemInfoUtils getExtendedSystemInfoUtils() {
        return this.systemInfoUtils;
    }

    public List<String> getWarningMessages() {
        if (this.warningMessages == null) {
            this.warningMessages = SystemEnvironmentChecklist.getEnglishWarningMessages();
        }
        return this.warningMessages;
    }

    public Set<AppliedPatchInfo> getAppliedPatches() {
        return AppliedPatches.getAppliedPatches();
    }
}

