/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.license.JiraLicenseUpdaterService;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.upgrade.BuildNumComparator;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.system.JiraSystemRestarter;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventType;
import java.text.NumberFormat;
import java.util.Arrays;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;

public class ConfirmInstallationWithLicense
extends JiraWebActionSupport {
    private static final String CROWD_EMBEDDED_INTEGRATION_VERSION = "602";
    private final JiraLicenseUpdaterService jiraLicenseService;
    private final BuildUtilsInfo buildUtilsInfo;
    private final JiraSystemRestarter jiraSystemRestarter;
    private final CrowdService crowdService;
    private final ExternalLinkUtil externalLinkUtil;
    private String userName;
    private String password;
    private String licenseString;
    private String licenseProblem;
    private boolean licenseUpdated = false;
    private boolean installationConfirmed = false;
    private JiraLicenseService.ValidationResult validationResult;
    private static final String A = "<a target=\"_blank\" href=\"";
    private static final String QT_GT = "\">";
    private static final String SLASH_A = "</a>";
    private static final int V1 = 1;

    public ConfirmInstallationWithLicense(JiraLicenseUpdaterService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, JiraSystemRestarter jiraSystemRestarter, ExternalLinkUtil externalLinkUtil, CrowdService crowdService) {
        this.crowdService = crowdService;
        this.jiraLicenseService = (JiraLicenseUpdaterService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.jiraSystemRestarter = (JiraSystemRestarter)Assertions.notNull((String)"jiraSystemRestarter", (Object)jiraSystemRestarter);
        this.externalLinkUtil = (ExternalLinkUtil)Assertions.notNull((String)"externalLinkUtil", (Object)externalLinkUtil);
    }

    private void workOutLicenseProblem() {
        LicenseDetails licenseDetails = this.getLicenseDetails();
        this.validationResult = this.jiraLicenseService.validate((I18nHelper)this, licenseDetails.getLicenseString());
        if (this.validationResult.getLicenseVersion() == 1) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            String upgradeLink = A + this.externalLinkUtil.getProperty("external.link.jira.upgrade.lic", Arrays.asList(this.buildUtilsInfo.getVersion(), this.buildUtilsInfo.getCurrentBuildNumber(), "enterprise", this.getServerId(), String.valueOf(this.validationResult.getTotalUserCount()), String.valueOf(this.validationResult.getActiveUserCount()))) + QT_GT;
            String evaluationLink = A + this.externalLinkUtil.getProperty("external.link.jira.license.view", Arrays.asList(this.buildUtilsInfo.getVersion(), this.buildUtilsInfo.getCurrentBuildNumber(), "enterprise", this.getServerId())) + QT_GT;
            this.licenseProblem = this.getText("setup.error.invalidlicensekey.wrong.license.version.my.atlassian.link", upgradeLink, SLASH_A, evaluationLink, SLASH_A);
            if (this.getUserInfoAvailable()) {
                this.licenseProblem = this.licenseProblem + "<p>" + this.getText("setup.error.invalidlicensekey.wrong.license.version.how.many.users", nf.format(this.validationResult.getTotalUserCount()), nf.format(this.validationResult.getActiveUserCount())) + "<p>" + this.getText("setup.error.invalidlicensekey.whatisactive", "<strong>", "</strong>");
            }
        } else {
            this.licenseProblem = this.isBuildPartnerNameExists() ? this.getText("setup.error.invalidlicensekey.confirminstall.problem.partnerset", this.buildUtilsInfo.getVersion(), this.buildUtilsInfo.getCurrentBuildNumber(), this.getBuildPartnerName()) : this.getText("setup.error.invalidlicensekey.confirminstall.problem.partnernotset", this.buildUtilsInfo.getVersion(), this.buildUtilsInfo.getCurrentBuildNumber());
        }
    }

    public String doDefault() throws Exception {
        this.workOutLicenseProblem();
        return "input";
    }

    protected void doValidation() {
        this.workOutLicenseProblem();
        if (this.getUserInfoAvailable()) {
            boolean hasAdminPermission;
            User user = this.crowdService.getUser(this.userName);
            if (user == null) {
                this.addErrorMessage(this.getText("admin.errors.invalid.username.or.pasword"));
                return;
            }
            try {
                this.crowdService.authenticate(this.userName, this.password);
            }
            catch (FailedAuthenticationException e) {
                this.addErrorMessage(this.getText("admin.errors.invalid.username.or.pasword"));
                return;
            }
            if (!this.nonAdminUpgradeAllowed() && !(hasAdminPermission = ManagerFactory.getPermissionManager().hasPermission(0, user))) {
                this.addError("userName", this.getText("admin.errors.no.admin.permission"));
            }
        }
        if (StringUtils.isNotBlank((String)this.licenseString)) {
            this.validationResult = this.jiraLicenseService.validate((I18nHelper)this, this.licenseString);
            this.addErrorCollection(this.validationResult.getErrorCollection());
        } else {
            this.addErrorMessage(this.getText("admin.errors.no.license.supplied"));
        }
    }

    public String doExecute() throws Exception {
        if (!StringUtils.isNotBlank((String)this.licenseString)) {
            throw new IllegalStateException("This will never happen!");
        }
        this.jiraLicenseService.setLicense(this.validationResult);
        this.licenseUpdated = true;
        this.jiraSystemRestarter.ariseSirJIRAandUpgradeThySelf(ActionContext.getServletContext());
        JohnsonEventContainer cont = JohnsonEventContainer.get((ServletContext)ServletActionContext.getServletContext());
        for (Event event : cont.getEvents()) {
            if (event == null || !event.getKey().equals((Object)EventType.get((String)"license-invalid"))) continue;
            cont.removeEvent(event);
        }
        return this.getRedirect("/");
    }

    public String getLicenseProblem() {
        return this.licenseProblem;
    }

    public LicenseDetails getLicenseDetails() {
        return this.jiraLicenseService.getLicense();
    }

    public String getLicensePurchaseDate() {
        return this.getLicenseDetails().getPurchaseDate(this.getOutlookDate());
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLicense(String licenseString) {
        this.licenseString = licenseString;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getLicense() {
        return this.licenseString;
    }

    public boolean isLicenseUpdated() {
        return this.licenseUpdated;
    }

    public boolean isInstallationConfirmed() {
        return this.installationConfirmed;
    }

    private boolean nonAdminUpgradeAllowed() {
        return Boolean.valueOf(System.getProperty("non.admin.upgrade"));
    }

    public String getBuildPartnerName() {
        return this.buildUtilsInfo.getBuildPartnerName();
    }

    public BuildUtilsInfo getBuildUtilsInfo() {
        return this.buildUtilsInfo;
    }

    public boolean isBuildPartnerNameExists() {
        return StringUtils.isNotBlank((String)this.getBuildPartnerName());
    }

    public boolean getUserInfoAvailable() {
        BuildNumComparator comparator = new BuildNumComparator();
        if (comparator.compare(this.buildUtilsInfo.getCurrentBuildNumber(), CROWD_EMBEDDED_INTEGRATION_VERSION) < 0) {
            return true;
        }
        String currentDatabaseVersion = this.getApplicationProperties().getString("jira.version.patched");
        return comparator.compare(currentDatabaseVersion, CROWD_EMBEDDED_INTEGRATION_VERSION) > 0;
    }
}

